/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.task;

import java.time.Duration;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Set;
import org.springframework.boot.context.properties.PropertyMapper;
import org.springframework.boot.task.SimpleAsyncTaskSchedulerCustomizer;
import org.springframework.scheduling.concurrent.SimpleAsyncTaskScheduler;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;

public class SimpleAsyncTaskSchedulerBuilder {
    private final String threadNamePrefix;
    private final Integer concurrencyLimit;
    private final Boolean virtualThreads;
    private final Set<SimpleAsyncTaskSchedulerCustomizer> customizers;
    private final Duration taskTerminationTimeout;

    public SimpleAsyncTaskSchedulerBuilder() {
        this(null, null, null, null, null);
    }

    private SimpleAsyncTaskSchedulerBuilder(String threadNamePrefix, Integer concurrencyLimit, Boolean virtualThreads, Set<SimpleAsyncTaskSchedulerCustomizer> taskSchedulerCustomizers, Duration taskTerminationTimeout) {
        this.threadNamePrefix = threadNamePrefix;
        this.concurrencyLimit = concurrencyLimit;
        this.virtualThreads = virtualThreads;
        this.customizers = taskSchedulerCustomizers;
        this.taskTerminationTimeout = taskTerminationTimeout;
    }

    public SimpleAsyncTaskSchedulerBuilder threadNamePrefix(String threadNamePrefix) {
        return new SimpleAsyncTaskSchedulerBuilder(threadNamePrefix, this.concurrencyLimit, this.virtualThreads, this.customizers, this.taskTerminationTimeout);
    }

    public SimpleAsyncTaskSchedulerBuilder concurrencyLimit(Integer concurrencyLimit) {
        return new SimpleAsyncTaskSchedulerBuilder(this.threadNamePrefix, concurrencyLimit, this.virtualThreads, this.customizers, this.taskTerminationTimeout);
    }

    public SimpleAsyncTaskSchedulerBuilder virtualThreads(Boolean virtualThreads) {
        return new SimpleAsyncTaskSchedulerBuilder(this.threadNamePrefix, this.concurrencyLimit, virtualThreads, this.customizers, this.taskTerminationTimeout);
    }

    public SimpleAsyncTaskSchedulerBuilder taskTerminationTimeout(Duration taskTerminationTimeout) {
        return new SimpleAsyncTaskSchedulerBuilder(this.threadNamePrefix, this.concurrencyLimit, this.virtualThreads, this.customizers, taskTerminationTimeout);
    }

    public SimpleAsyncTaskSchedulerBuilder customizers(SimpleAsyncTaskSchedulerCustomizer ... customizers) {
        Assert.notNull((Object)customizers, "Customizers must not be null");
        return this.customizers(Arrays.asList(customizers));
    }

    public SimpleAsyncTaskSchedulerBuilder customizers(Iterable<? extends SimpleAsyncTaskSchedulerCustomizer> customizers) {
        Assert.notNull(customizers, "Customizers must not be null");
        return new SimpleAsyncTaskSchedulerBuilder(this.threadNamePrefix, this.concurrencyLimit, this.virtualThreads, this.append(null, customizers), this.taskTerminationTimeout);
    }

    public SimpleAsyncTaskSchedulerBuilder additionalCustomizers(SimpleAsyncTaskSchedulerCustomizer ... customizers) {
        Assert.notNull((Object)customizers, "Customizers must not be null");
        return this.additionalCustomizers(Arrays.asList(customizers));
    }

    public SimpleAsyncTaskSchedulerBuilder additionalCustomizers(Iterable<? extends SimpleAsyncTaskSchedulerCustomizer> customizers) {
        Assert.notNull(customizers, "Customizers must not be null");
        return new SimpleAsyncTaskSchedulerBuilder(this.threadNamePrefix, this.concurrencyLimit, this.virtualThreads, this.append(this.customizers, customizers), this.taskTerminationTimeout);
    }

    public SimpleAsyncTaskScheduler build() {
        return this.configure(new SimpleAsyncTaskScheduler());
    }

    public <T extends SimpleAsyncTaskScheduler> T configure(T taskScheduler) {
        PropertyMapper map2 = PropertyMapper.get().alwaysApplyingWhenNonNull();
        map2.from(this.threadNamePrefix).to(taskScheduler::setThreadNamePrefix);
        map2.from(this.concurrencyLimit).to(taskScheduler::setConcurrencyLimit);
        map2.from(this.virtualThreads).to(taskScheduler::setVirtualThreads);
        map2.from(this.taskTerminationTimeout).as(Duration::toMillis).to(taskScheduler::setTaskTerminationTimeout);
        if (!CollectionUtils.isEmpty(this.customizers)) {
            this.customizers.forEach(customizer2 -> customizer2.customize(taskScheduler));
        }
        return taskScheduler;
    }

    private <T> Set<T> append(Set<T> set2, Iterable<? extends T> additions) {
        LinkedHashSet<T> result2 = new LinkedHashSet<T>(set2 != null ? set2 : Collections.emptySet());
        additions.forEach(result2::add);
        return Collections.unmodifiableSet(result2);
    }
}

