/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.task;

import java.time.Duration;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Set;
import org.springframework.beans.BeanUtils;
import org.springframework.boot.context.properties.PropertyMapper;
import org.springframework.boot.task.SimpleAsyncTaskExecutorCustomizer;
import org.springframework.core.task.SimpleAsyncTaskExecutor;
import org.springframework.core.task.TaskDecorator;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;

public class SimpleAsyncTaskExecutorBuilder {
    private final Boolean virtualThreads;
    private final String threadNamePrefix;
    private final Integer concurrencyLimit;
    private final TaskDecorator taskDecorator;
    private final Set<SimpleAsyncTaskExecutorCustomizer> customizers;
    private final Duration taskTerminationTimeout;

    public SimpleAsyncTaskExecutorBuilder() {
        this(null, null, null, null, null, null);
    }

    private SimpleAsyncTaskExecutorBuilder(Boolean virtualThreads, String threadNamePrefix, Integer concurrencyLimit, TaskDecorator taskDecorator, Set<SimpleAsyncTaskExecutorCustomizer> customizers, Duration taskTerminationTimeout) {
        this.virtualThreads = virtualThreads;
        this.threadNamePrefix = threadNamePrefix;
        this.concurrencyLimit = concurrencyLimit;
        this.taskDecorator = taskDecorator;
        this.customizers = customizers;
        this.taskTerminationTimeout = taskTerminationTimeout;
    }

    public SimpleAsyncTaskExecutorBuilder threadNamePrefix(String threadNamePrefix) {
        return new SimpleAsyncTaskExecutorBuilder(this.virtualThreads, threadNamePrefix, this.concurrencyLimit, this.taskDecorator, this.customizers, this.taskTerminationTimeout);
    }

    public SimpleAsyncTaskExecutorBuilder virtualThreads(Boolean virtualThreads) {
        return new SimpleAsyncTaskExecutorBuilder(virtualThreads, this.threadNamePrefix, this.concurrencyLimit, this.taskDecorator, this.customizers, this.taskTerminationTimeout);
    }

    public SimpleAsyncTaskExecutorBuilder concurrencyLimit(Integer concurrencyLimit) {
        return new SimpleAsyncTaskExecutorBuilder(this.virtualThreads, this.threadNamePrefix, concurrencyLimit, this.taskDecorator, this.customizers, this.taskTerminationTimeout);
    }

    public SimpleAsyncTaskExecutorBuilder taskDecorator(TaskDecorator taskDecorator) {
        return new SimpleAsyncTaskExecutorBuilder(this.virtualThreads, this.threadNamePrefix, this.concurrencyLimit, taskDecorator, this.customizers, this.taskTerminationTimeout);
    }

    public SimpleAsyncTaskExecutorBuilder taskTerminationTimeout(Duration taskTerminationTimeout) {
        return new SimpleAsyncTaskExecutorBuilder(this.virtualThreads, this.threadNamePrefix, this.concurrencyLimit, this.taskDecorator, this.customizers, taskTerminationTimeout);
    }

    public SimpleAsyncTaskExecutorBuilder customizers(SimpleAsyncTaskExecutorCustomizer ... customizers) {
        Assert.notNull((Object)customizers, "Customizers must not be null");
        return this.customizers(Arrays.asList(customizers));
    }

    public SimpleAsyncTaskExecutorBuilder customizers(Iterable<? extends SimpleAsyncTaskExecutorCustomizer> customizers) {
        Assert.notNull(customizers, "Customizers must not be null");
        return new SimpleAsyncTaskExecutorBuilder(this.virtualThreads, this.threadNamePrefix, this.concurrencyLimit, this.taskDecorator, this.append(null, customizers), this.taskTerminationTimeout);
    }

    public SimpleAsyncTaskExecutorBuilder additionalCustomizers(SimpleAsyncTaskExecutorCustomizer ... customizers) {
        Assert.notNull((Object)customizers, "Customizers must not be null");
        return this.additionalCustomizers(Arrays.asList(customizers));
    }

    public SimpleAsyncTaskExecutorBuilder additionalCustomizers(Iterable<? extends SimpleAsyncTaskExecutorCustomizer> customizers) {
        Assert.notNull(customizers, "Customizers must not be null");
        return new SimpleAsyncTaskExecutorBuilder(this.virtualThreads, this.threadNamePrefix, this.concurrencyLimit, this.taskDecorator, this.append(this.customizers, customizers), this.taskTerminationTimeout);
    }

    public SimpleAsyncTaskExecutor build() {
        return this.configure(new SimpleAsyncTaskExecutor());
    }

    public <T extends SimpleAsyncTaskExecutor> T build(Class<T> taskExecutorClass) {
        return (T)this.configure((SimpleAsyncTaskExecutor)BeanUtils.instantiateClass(taskExecutorClass));
    }

    public <T extends SimpleAsyncTaskExecutor> T configure(T taskExecutor) {
        PropertyMapper map2 = PropertyMapper.get().alwaysApplyingWhenNonNull();
        map2.from(this.virtualThreads).to(taskExecutor::setVirtualThreads);
        map2.from(this.threadNamePrefix).whenHasText().to(taskExecutor::setThreadNamePrefix);
        map2.from(this.concurrencyLimit).to(taskExecutor::setConcurrencyLimit);
        map2.from(this.taskDecorator).to(taskExecutor::setTaskDecorator);
        map2.from(this.taskTerminationTimeout).as(Duration::toMillis).to(taskExecutor::setTaskTerminationTimeout);
        if (!CollectionUtils.isEmpty(this.customizers)) {
            this.customizers.forEach(customizer2 -> customizer2.customize(taskExecutor));
        }
        return taskExecutor;
    }

    private <T> Set<T> append(Set<T> set2, Iterable<? extends T> additions) {
        LinkedHashSet<T> result2 = new LinkedHashSet<T>(set2 != null ? set2 : Collections.emptySet());
        additions.forEach(result2::add);
        return Collections.unmodifiableSet(result2);
    }
}

