/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.system;

import java.io.File;
import java.io.IOException;
import java.nio.file.FileSystem;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.nio.file.attribute.PosixFilePermission;
import java.nio.file.attribute.PosixFilePermissions;
import java.security.MessageDigest;
import java.util.EnumSet;
import java.util.HexFormat;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.springframework.boot.system.ApplicationHome;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

public class ApplicationTemp {
    private static final FileAttribute<?>[] NO_FILE_ATTRIBUTES = new FileAttribute[0];
    private static final EnumSet<PosixFilePermission> DIRECTORY_PERMISSIONS = EnumSet.of(PosixFilePermission.OWNER_READ, PosixFilePermission.OWNER_WRITE, PosixFilePermission.OWNER_EXECUTE);
    private final Class<?> sourceClass;
    private final Lock pathLock = new ReentrantLock();
    private volatile Path path;

    public ApplicationTemp() {
        this(null);
    }

    public ApplicationTemp(Class<?> sourceClass) {
        this.sourceClass = sourceClass;
    }

    public String toString() {
        return this.getDir().getAbsolutePath();
    }

    public File getDir() {
        return this.getPath().toFile();
    }

    public File getDir(String subDir) {
        return this.createDirectory(this.getPath().resolve(subDir)).toFile();
    }

    private Path getPath() {
        if (this.path == null) {
            this.pathLock.lock();
            try {
                if (this.path == null) {
                    String hash2 = HexFormat.of().withUpperCase().formatHex(this.generateHash(this.sourceClass));
                    this.path = this.createDirectory(this.getTempDirectory().resolve(hash2));
                }
            }
            finally {
                this.pathLock.unlock();
            }
        }
        return this.path;
    }

    private Path createDirectory(Path path2) {
        try {
            if (!Files.exists(path2, new LinkOption[0])) {
                Files.createDirectory(path2, this.getFileAttributes(path2.getFileSystem(), DIRECTORY_PERMISSIONS));
            }
            return path2;
        }
        catch (IOException ex) {
            throw new IllegalStateException("Unable to create application temp directory " + path2, ex);
        }
    }

    private FileAttribute<?>[] getFileAttributes(FileSystem fileSystem, EnumSet<PosixFilePermission> ownerReadWrite) {
        if (!fileSystem.supportedFileAttributeViews().contains("posix")) {
            return NO_FILE_ATTRIBUTES;
        }
        return new FileAttribute[]{PosixFilePermissions.asFileAttribute(ownerReadWrite)};
    }

    private Path getTempDirectory() {
        String property = System.getProperty("java.io.tmpdir");
        Assert.state(StringUtils.hasLength(property), "No 'java.io.tmpdir' property set");
        Path tempDirectory = Paths.get(property, new String[0]);
        Assert.state(Files.exists(tempDirectory, new LinkOption[0]), () -> "Temp directory '" + tempDirectory + "' does not exist");
        Assert.state(Files.isDirectory(tempDirectory, new LinkOption[0]), () -> "Temp location '" + tempDirectory + "' is not a directory");
        return tempDirectory;
    }

    private byte[] generateHash(Class<?> sourceClass) {
        ApplicationHome home2 = new ApplicationHome(sourceClass);
        try {
            MessageDigest digest2 = MessageDigest.getInstance("SHA-1");
            this.update(digest2, home2.getSource());
            this.update(digest2, home2.getDir());
            this.update(digest2, System.getProperty("user.dir"));
            this.update(digest2, System.getProperty("java.home"));
            this.update(digest2, System.getProperty("java.class.path"));
            this.update(digest2, System.getProperty("sun.java.command"));
            this.update(digest2, System.getProperty("sun.boot.class.path"));
            return digest2.digest();
        }
        catch (Exception ex) {
            throw new IllegalStateException(ex);
        }
    }

    private void update(MessageDigest digest2, Object source2) {
        if (source2 != null) {
            digest2.update(this.getUpdateSourceBytes(source2));
        }
    }

    private byte[] getUpdateSourceBytes(Object source2) {
        if (source2 instanceof File) {
            File file2 = (File)source2;
            return this.getUpdateSourceBytes(file2.getAbsolutePath());
        }
        return source2.toString().getBytes();
    }
}

