/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.system;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileWriter;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.attribute.PosixFilePermission;
import java.util.Set;
import org.springframework.util.Assert;
import org.springframework.util.ObjectUtils;

public class ApplicationPid {
    private static final PosixFilePermission[] WRITE_PERMISSIONS = new PosixFilePermission[]{PosixFilePermission.OWNER_WRITE, PosixFilePermission.GROUP_WRITE, PosixFilePermission.OTHERS_WRITE};
    private final String pid;

    public ApplicationPid() {
        this.pid = this.getPid();
    }

    protected ApplicationPid(String pid2) {
        this.pid = pid2;
    }

    private String getPid() {
        try {
            return Long.toString(ProcessHandle.current().pid());
        }
        catch (Throwable ex) {
            return null;
        }
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof ApplicationPid) {
            ApplicationPid other = (ApplicationPid)obj;
            return ObjectUtils.nullSafeEquals(this.pid, other.pid);
        }
        return false;
    }

    public int hashCode() {
        return ObjectUtils.nullSafeHashCode(this.pid);
    }

    public String toString() {
        return this.pid != null ? this.pid : "???";
    }

    public void write(File file2) throws IOException {
        Assert.state(this.pid != null, "No PID available");
        this.createParentDirectory(file2);
        if (file2.exists()) {
            this.assertCanOverwrite(file2);
        }
        try (FileWriter writer = new FileWriter(file2);){
            writer.append(this.pid);
        }
    }

    private void createParentDirectory(File file2) {
        File parent = file2.getParentFile();
        if (parent != null) {
            parent.mkdirs();
        }
    }

    private void assertCanOverwrite(File file2) throws IOException {
        if (!file2.canWrite() || !this.canWritePosixFile(file2)) {
            throw new FileNotFoundException(file2 + " (permission denied)");
        }
    }

    private boolean canWritePosixFile(File file2) throws IOException {
        try {
            Set<PosixFilePermission> permissions = Files.getPosixFilePermissions(file2.toPath(), new LinkOption[0]);
            for (PosixFilePermission permission : WRITE_PERMISSIONS) {
                if (!permissions.contains((Object)permission)) continue;
                return true;
            }
            return false;
        }
        catch (UnsupportedOperationException ex) {
            return true;
        }
    }
}

