/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.system;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.JarURLConnection;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLConnection;
import java.security.CodeSource;
import java.security.ProtectionDomain;
import java.util.Enumeration;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import org.springframework.util.ClassUtils;
import org.springframework.util.StringUtils;

public class ApplicationHome {
    private final File source;
    private final File dir;

    public ApplicationHome() {
        this(null);
    }

    public ApplicationHome(Class<?> sourceClass) {
        this.source = this.findSource(sourceClass != null ? sourceClass : this.getStartClass());
        this.dir = this.findHomeDir(this.source);
    }

    private Class<?> getStartClass() {
        try {
            ClassLoader classLoader = this.getClass().getClassLoader();
            return this.getStartClass(classLoader.getResources("META-INF/MANIFEST.MF"));
        }
        catch (Exception ex) {
            return null;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Class<?> getStartClass(Enumeration<URL> manifestResources) {
        while (manifestResources.hasMoreElements()) {
            try {
                InputStream inputStream = manifestResources.nextElement().openStream();
                try {
                    Manifest manifest = new Manifest(inputStream);
                    String startClass = manifest.getMainAttributes().getValue("Start-Class");
                    if (startClass == null) continue;
                    Class<?> clazz = ClassUtils.forName(startClass, this.getClass().getClassLoader());
                    return clazz;
                }
                finally {
                    if (inputStream == null) continue;
                    inputStream.close();
                }
            }
            catch (Exception exception2) {}
        }
        return null;
    }

    private File findSource(Class<?> sourceClass) {
        try {
            File source2;
            ProtectionDomain domain = sourceClass != null ? sourceClass.getProtectionDomain() : null;
            CodeSource codeSource = domain != null ? domain.getCodeSource() : null;
            URL location = codeSource != null ? codeSource.getLocation() : null;
            File file2 = source2 = location != null ? this.findSource(location) : null;
            if (source2 != null && source2.exists() && !this.isUnitTest()) {
                return source2.getAbsoluteFile();
            }
        }
        catch (Exception exception2) {
            // empty catch block
        }
        return null;
    }

    private boolean isUnitTest() {
        try {
            StackTraceElement[] stackTrace = Thread.currentThread().getStackTrace();
            for (int i2 = stackTrace.length - 1; i2 >= 0; --i2) {
                if (!stackTrace[i2].getClassName().startsWith("org.junit.")) continue;
                return true;
            }
        }
        catch (Exception exception2) {
            // empty catch block
        }
        return false;
    }

    private File findSource(URL location) throws IOException, URISyntaxException {
        URLConnection connection = location.openConnection();
        if (connection instanceof JarURLConnection) {
            JarURLConnection jarURLConnection = (JarURLConnection)connection;
            return this.getRootJarFile(jarURLConnection.getJarFile());
        }
        return new File(location.toURI());
    }

    private File getRootJarFile(JarFile jarFile) {
        String name2 = jarFile.getName();
        int separator = name2.indexOf("!/");
        if (separator > 0) {
            name2 = name2.substring(0, separator);
        }
        return new File(name2);
    }

    private File findHomeDir(File source2) {
        File homeDir = source2;
        File file2 = homeDir = homeDir != null ? homeDir : this.findDefaultHomeDir();
        if (homeDir.isFile()) {
            homeDir = homeDir.getParentFile();
        }
        homeDir = homeDir.exists() ? homeDir : new File(".");
        return homeDir.getAbsoluteFile();
    }

    private File findDefaultHomeDir() {
        String userDir = System.getProperty("user.dir");
        return new File(StringUtils.hasLength(userDir) ? userDir : ".");
    }

    public File getSource() {
        return this.source;
    }

    public File getDir() {
        return this.dir;
    }

    public String toString() {
        return this.getDir().toString();
    }
}

