/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.ssl.pem;

import java.security.PrivateKey;
import java.security.cert.X509Certificate;
import java.util.List;
import org.springframework.boot.ssl.pem.LoadedPemSslStore;
import org.springframework.boot.ssl.pem.PemSslStoreDetails;
import org.springframework.util.Assert;

public interface PemSslStore {
    public String type();

    public String alias();

    public String password();

    public List<X509Certificate> certificates();

    public PrivateKey privateKey();

    default public PemSslStore withAlias(String alias) {
        return PemSslStore.of(this.type(), alias, this.password(), this.certificates(), this.privateKey());
    }

    default public PemSslStore withPassword(String password) {
        return PemSslStore.of(this.type(), this.alias(), password, this.certificates(), this.privateKey());
    }

    public static PemSslStore load(PemSslStoreDetails details) {
        if (details == null || details.isEmpty()) {
            return null;
        }
        return new LoadedPemSslStore(details);
    }

    public static PemSslStore of(String type2, List<X509Certificate> certificates, PrivateKey privateKey) {
        return PemSslStore.of(type2, null, null, certificates, privateKey);
    }

    public static PemSslStore of(List<X509Certificate> certificates, PrivateKey privateKey) {
        return PemSslStore.of(null, null, null, certificates, privateKey);
    }

    public static PemSslStore of(final String type2, final String alias, final String password, final List<X509Certificate> certificates, final PrivateKey privateKey) {
        Assert.notEmpty(certificates, "Certificates must not be empty");
        return new PemSslStore(){

            @Override
            public String type() {
                return type2;
            }

            @Override
            public String alias() {
                return alias;
            }

            @Override
            public String password() {
                return password;
            }

            @Override
            public List<X509Certificate> certificates() {
                return certificates;
            }

            @Override
            public PrivateKey privateKey() {
                return privateKey;
            }
        };
    }
}

