/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.ssl.jks;

import java.io.IOException;
import java.io.InputStream;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.cert.CertificateException;
import org.springframework.boot.io.ApplicationResourceLoader;
import org.springframework.boot.ssl.SslStoreBundle;
import org.springframework.boot.ssl.jks.JksSslStoreDetails;
import org.springframework.core.io.Resource;
import org.springframework.core.style.ToStringCreator;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

public class JksSslStoreBundle
implements SslStoreBundle {
    private final JksSslStoreDetails keyStoreDetails;
    private final KeyStore keyStore;
    private final KeyStore trustStore;

    public JksSslStoreBundle(JksSslStoreDetails keyStoreDetails, JksSslStoreDetails trustStoreDetails) {
        this.keyStoreDetails = keyStoreDetails;
        this.keyStore = this.createKeyStore("key", this.keyStoreDetails);
        this.trustStore = this.createKeyStore("trust", trustStoreDetails);
    }

    @Override
    public KeyStore getKeyStore() {
        return this.keyStore;
    }

    @Override
    public String getKeyStorePassword() {
        return this.keyStoreDetails != null ? this.keyStoreDetails.password() : null;
    }

    @Override
    public KeyStore getTrustStore() {
        return this.trustStore;
    }

    private KeyStore createKeyStore(String name2, JksSslStoreDetails details) {
        if (details == null || details.isEmpty()) {
            return null;
        }
        try {
            String type2 = !StringUtils.hasText(details.type()) ? KeyStore.getDefaultType() : details.type();
            char[] password = details.password() != null ? details.password().toCharArray() : null;
            String location = details.location();
            KeyStore store = this.getKeyStoreInstance(type2, details.provider());
            if (this.isHardwareKeystoreType(type2)) {
                this.loadHardwareKeyStore(store, location, password);
            } else {
                this.loadKeyStore(store, location, password);
            }
            return store;
        }
        catch (Exception ex) {
            throw new IllegalStateException("Unable to create %s store: %s".formatted(name2, ex.getMessage()), ex);
        }
    }

    private KeyStore getKeyStoreInstance(String type2, String provider) throws KeyStoreException, NoSuchProviderException {
        return !StringUtils.hasText(provider) ? KeyStore.getInstance(type2) : KeyStore.getInstance(type2, provider);
    }

    private boolean isHardwareKeystoreType(String type2) {
        return type2.equalsIgnoreCase("PKCS11");
    }

    private void loadHardwareKeyStore(KeyStore store, String location, char[] password) throws IOException, NoSuchAlgorithmException, CertificateException {
        Assert.state(!StringUtils.hasText(location), () -> "Location is '%s', but must be empty or null for PKCS11 hardware key stores".formatted(location));
        store.load(null, password);
    }

    private void loadKeyStore(KeyStore store, String location, char[] password) {
        Assert.state(StringUtils.hasText(location), () -> "Location must not be empty or null");
        try {
            Resource resource = new ApplicationResourceLoader().getResource(location);
            try (InputStream stream = resource.getInputStream();){
                store.load(stream, password);
            }
        }
        catch (Exception ex) {
            throw new IllegalStateException("Could not load store from '" + location + "'", ex);
        }
    }

    public String toString() {
        ToStringCreator creator = new ToStringCreator(this);
        creator.append("keyStore.type", this.keyStore != null ? this.keyStore.getType() : "none");
        String keyStorePassword = this.getKeyStorePassword();
        creator.append("keyStorePassword", keyStorePassword != null ? "******" : null);
        creator.append("trustStore.type", this.trustStore != null ? this.trustStore.getType() : "none");
        return creator.toString();
    }
}

