/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.ssl;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Set;
import org.springframework.core.style.ToStringCreator;

public interface SslOptions {
    public static final SslOptions NONE = SslOptions.of((Set<String>)null, (Set<String>)null);

    default public boolean isSpecified() {
        return this.getCiphers() != null && this.getEnabledProtocols() != null;
    }

    public String[] getCiphers();

    public String[] getEnabledProtocols();

    public static SslOptions of(final String[] ciphers, final String[] enabledProtocols) {
        return new SslOptions(){

            @Override
            public String[] getCiphers() {
                return ciphers;
            }

            @Override
            public String[] getEnabledProtocols() {
                return enabledProtocols;
            }

            public String toString() {
                ToStringCreator creator = new ToStringCreator(this);
                creator.append("ciphers", ciphers);
                creator.append("enabledProtocols", enabledProtocols);
                return creator.toString();
            }
        };
    }

    public static SslOptions of(Set<String> ciphers, Set<String> enabledProtocols) {
        return SslOptions.of(SslOptions.toArray(ciphers), SslOptions.toArray(enabledProtocols));
    }

    public static Set<String> asSet(String[] array2) {
        return array2 != null ? Collections.unmodifiableSet(new LinkedHashSet<String>(Arrays.asList(array2))) : null;
    }

    private static String[] toArray(Collection<String> collection) {
        return collection != null ? (String[])collection.toArray(String[]::new) : null;
    }
}

