/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.ssl;

import javax.net.ssl.SSLContext;
import org.springframework.boot.ssl.SslBundleKey;
import org.springframework.boot.ssl.SslManagerBundle;
import org.springframework.boot.ssl.SslOptions;
import org.springframework.boot.ssl.SslStoreBundle;
import org.springframework.core.style.ToStringCreator;
import org.springframework.util.StringUtils;

public interface SslBundle {
    public static final String DEFAULT_PROTOCOL = "TLS";

    public SslStoreBundle getStores();

    public SslBundleKey getKey();

    public SslOptions getOptions();

    public String getProtocol();

    public SslManagerBundle getManagers();

    default public SSLContext createSslContext() {
        return this.getManagers().createSslContext(this.getProtocol());
    }

    public static SslBundle of(SslStoreBundle stores) {
        return SslBundle.of(stores, null, null);
    }

    public static SslBundle of(SslStoreBundle stores, SslBundleKey key2) {
        return SslBundle.of(stores, key2, null);
    }

    public static SslBundle of(SslStoreBundle stores, SslBundleKey key2, SslOptions options2) {
        return SslBundle.of(stores, key2, options2, null);
    }

    public static SslBundle of(SslStoreBundle stores, SslBundleKey key2, SslOptions options2, String protocol2) {
        return SslBundle.of(stores, key2, options2, protocol2, null);
    }

    public static SslBundle of(final SslStoreBundle stores, final SslBundleKey key2, final SslOptions options2, final String protocol2, SslManagerBundle managers) {
        final SslManagerBundle managersToUse = managers != null ? managers : SslManagerBundle.from(stores, key2);
        return new SslBundle(){

            @Override
            public SslStoreBundle getStores() {
                return stores != null ? stores : SslStoreBundle.NONE;
            }

            @Override
            public SslBundleKey getKey() {
                return key2 != null ? key2 : SslBundleKey.NONE;
            }

            @Override
            public SslOptions getOptions() {
                return options2 != null ? options2 : SslOptions.NONE;
            }

            @Override
            public String getProtocol() {
                return !StringUtils.hasText(protocol2) ? SslBundle.DEFAULT_PROTOCOL : protocol2;
            }

            @Override
            public SslManagerBundle getManagers() {
                return managersToUse;
            }

            public String toString() {
                ToStringCreator creator = new ToStringCreator(this);
                creator.append("key", this.getKey());
                creator.append("options", this.getOptions());
                creator.append("protocol", this.getProtocol());
                creator.append("stores", this.getStores());
                return creator.toString();
            }
        };
    }
}

