/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.ssl;

import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.function.Consumer;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.boot.ssl.NoSuchSslBundleException;
import org.springframework.boot.ssl.SslBundle;
import org.springframework.boot.ssl.SslBundleRegistry;
import org.springframework.boot.ssl.SslBundles;
import org.springframework.core.log.LogMessage;
import org.springframework.util.Assert;

public class DefaultSslBundleRegistry
implements SslBundleRegistry,
SslBundles {
    private static final Log logger = LogFactory.getLog(DefaultSslBundleRegistry.class);
    private final Map<String, RegisteredSslBundle> registeredBundles = new ConcurrentHashMap<String, RegisteredSslBundle>();

    public DefaultSslBundleRegistry() {
    }

    public DefaultSslBundleRegistry(String name2, SslBundle bundle) {
        this.registerBundle(name2, bundle);
    }

    @Override
    public void registerBundle(String name2, SslBundle bundle) {
        Assert.notNull((Object)name2, "Name must not be null");
        Assert.notNull((Object)bundle, "Bundle must not be null");
        RegisteredSslBundle previous = this.registeredBundles.putIfAbsent(name2, new RegisteredSslBundle(name2, bundle));
        Assert.state(previous == null, () -> "Cannot replace existing SSL bundle '%s'".formatted(name2));
    }

    @Override
    public void updateBundle(String name2, SslBundle updatedBundle) {
        this.getRegistered(name2).update(updatedBundle);
    }

    @Override
    public SslBundle getBundle(String name2) {
        return this.getRegistered(name2).getBundle();
    }

    @Override
    public void addBundleUpdateHandler(String name2, Consumer<SslBundle> updateHandler) throws NoSuchSslBundleException {
        this.getRegistered(name2).addUpdateHandler(updateHandler);
    }

    private RegisteredSslBundle getRegistered(String name2) throws NoSuchSslBundleException {
        Assert.notNull((Object)name2, "Name must not be null");
        RegisteredSslBundle registered = this.registeredBundles.get(name2);
        if (registered == null) {
            throw new NoSuchSslBundleException(name2, "SSL bundle name '%s' cannot be found".formatted(name2));
        }
        return registered;
    }

    private static class RegisteredSslBundle {
        private final String name;
        private final List<Consumer<SslBundle>> updateHandlers = new CopyOnWriteArrayList<Consumer<SslBundle>>();
        private volatile SslBundle bundle;

        RegisteredSslBundle(String name2, SslBundle bundle) {
            this.name = name2;
            this.bundle = bundle;
        }

        void update(SslBundle updatedBundle) {
            Assert.notNull((Object)updatedBundle, "UpdatedBundle must not be null");
            this.bundle = updatedBundle;
            if (this.updateHandlers.isEmpty()) {
                logger.warn(LogMessage.format("SSL bundle '%s' has been updated but may be in use by a technology that doesn't support SSL reloading", (Object)this.name));
            }
            this.updateHandlers.forEach(handler -> handler.accept(updatedBundle));
        }

        SslBundle getBundle() {
            return this.bundle;
        }

        void addUpdateHandler(Consumer<SslBundle> updateHandler) {
            Assert.notNull(updateHandler, "UpdateHandler must not be null");
            this.updateHandlers.add(updateHandler);
        }
    }
}

