/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.sql.init.dependency;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import org.springframework.beans.factory.BeanFactoryUtils;
import org.springframework.beans.factory.ListableBeanFactory;

class BeansOfTypeDetector {
    private final Set<Class<?>> types;

    BeansOfTypeDetector(Set<Class<?>> types) {
        this.types = types;
    }

    Set<String> detect(ListableBeanFactory beanFactory) {
        HashSet<String> beanNames = new HashSet<String>();
        for (Class<?> type2 : this.types) {
            try {
                String[] names2 = beanFactory.getBeanNamesForType(type2, true, false);
                Arrays.stream(names2).map(BeanFactoryUtils::transformedBeanName).forEach(beanNames::add);
            }
            catch (Throwable throwable) {}
        }
        return beanNames;
    }
}

