/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.sql.init;

import java.io.IOException;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.boot.sql.init.DatabaseInitializationMode;
import org.springframework.boot.sql.init.DatabaseInitializationSettings;
import org.springframework.context.ResourceLoaderAware;
import org.springframework.core.io.Resource;
import org.springframework.core.io.ResourceLoader;
import org.springframework.core.io.support.ResourcePatternResolver;
import org.springframework.core.io.support.ResourcePatternUtils;
import org.springframework.util.CollectionUtils;

public abstract class AbstractScriptDatabaseInitializer
implements ResourceLoaderAware,
InitializingBean {
    private static final String OPTIONAL_LOCATION_PREFIX = "optional:";
    private final DatabaseInitializationSettings settings;
    private volatile ResourceLoader resourceLoader;

    protected AbstractScriptDatabaseInitializer(DatabaseInitializationSettings settings) {
        this.settings = settings;
    }

    @Override
    public void setResourceLoader(ResourceLoader resourceLoader) {
        this.resourceLoader = resourceLoader;
    }

    @Override
    public void afterPropertiesSet() throws Exception {
        this.initializeDatabase();
    }

    public boolean initializeDatabase() {
        ScriptLocationResolver locationResolver = new ScriptLocationResolver(this.resourceLoader);
        boolean initialized = this.applySchemaScripts(locationResolver);
        return this.applyDataScripts(locationResolver) || initialized;
    }

    private boolean isEnabled() {
        if (this.settings.getMode() == DatabaseInitializationMode.NEVER) {
            return false;
        }
        return this.settings.getMode() == DatabaseInitializationMode.ALWAYS || this.isEmbeddedDatabase();
    }

    protected boolean isEmbeddedDatabase() {
        throw new IllegalStateException("Database initialization mode is '" + this.settings.getMode() + "' and database type is unknown");
    }

    private boolean applySchemaScripts(ScriptLocationResolver locationResolver) {
        return this.applyScripts(this.settings.getSchemaLocations(), "schema", locationResolver);
    }

    private boolean applyDataScripts(ScriptLocationResolver locationResolver) {
        return this.applyScripts(this.settings.getDataLocations(), "data", locationResolver);
    }

    private boolean applyScripts(List<String> locations, String type2, ScriptLocationResolver locationResolver) {
        List<Resource> scripts = this.getScripts(locations, type2, locationResolver);
        if (!scripts.isEmpty() && this.isEnabled()) {
            this.runScripts(scripts);
            return true;
        }
        return false;
    }

    private List<Resource> getScripts(List<String> locations, String type2, ScriptLocationResolver locationResolver) {
        if (CollectionUtils.isEmpty(locations)) {
            return Collections.emptyList();
        }
        ArrayList<Resource> resources = new ArrayList<Resource>();
        for (String location : locations) {
            boolean optional = location.startsWith(OPTIONAL_LOCATION_PREFIX);
            if (optional) {
                location = location.substring(OPTIONAL_LOCATION_PREFIX.length());
            }
            for (Resource resource : this.doGetResources(location, locationResolver)) {
                if (resource.isReadable()) {
                    resources.add(resource);
                    continue;
                }
                if (optional) continue;
                throw new IllegalStateException("No " + type2 + " scripts found at location '" + location + "'");
            }
        }
        return resources;
    }

    private List<Resource> doGetResources(String location, ScriptLocationResolver locationResolver) {
        try {
            return locationResolver.resolve(location);
        }
        catch (Exception ex) {
            throw new IllegalStateException("Unable to load resources from " + location, ex);
        }
    }

    private void runScripts(List<Resource> resources) {
        this.runScripts(new Scripts(resources).continueOnError(this.settings.isContinueOnError()).separator(this.settings.getSeparator()).encoding(this.settings.getEncoding()));
    }

    protected abstract void runScripts(Scripts var1);

    private static class ScriptLocationResolver {
        private final ResourcePatternResolver resourcePatternResolver;

        ScriptLocationResolver(ResourceLoader resourceLoader) {
            this.resourcePatternResolver = ResourcePatternUtils.getResourcePatternResolver(resourceLoader);
        }

        private List<Resource> resolve(String location) throws IOException {
            ArrayList<Resource> resources = new ArrayList<Resource>(Arrays.asList(this.resourcePatternResolver.getResources(location)));
            resources.sort((r1, r2) -> {
                try {
                    return r1.getURL().toString().compareTo(r2.getURL().toString());
                }
                catch (IOException ex) {
                    return 0;
                }
            });
            return resources;
        }
    }

    public static class Scripts
    implements Iterable<Resource> {
        private final List<Resource> resources;
        private boolean continueOnError = false;
        private String separator = ";";
        private Charset encoding;

        public Scripts(List<Resource> resources) {
            this.resources = resources;
        }

        @Override
        public Iterator<Resource> iterator() {
            return this.resources.iterator();
        }

        public Scripts continueOnError(boolean continueOnError) {
            this.continueOnError = continueOnError;
            return this;
        }

        public boolean isContinueOnError() {
            return this.continueOnError;
        }

        public Scripts separator(String separator) {
            this.separator = separator;
            return this;
        }

        public String getSeparator() {
            return this.separator;
        }

        public Scripts encoding(Charset encoding2) {
            this.encoding = encoding2;
            return this;
        }

        public Charset getEncoding() {
            return this.encoding;
        }
    }
}

