/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.rsocket.context;

import java.util.HashMap;
import java.util.Map;
import org.springframework.boot.rsocket.context.RSocketServerInitializedEvent;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextInitializer;
import org.springframework.context.ApplicationListener;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.core.env.MapPropertySource;
import org.springframework.core.env.MutablePropertySources;
import org.springframework.core.env.PropertySource;

public class RSocketPortInfoApplicationContextInitializer
implements ApplicationContextInitializer<ConfigurableApplicationContext> {
    @Override
    public void initialize(ConfigurableApplicationContext applicationContext) {
        applicationContext.addApplicationListener(new Listener(applicationContext));
    }

    private static class Listener
    implements ApplicationListener<RSocketServerInitializedEvent> {
        private static final String PROPERTY_NAME = "local.rsocket.server.port";
        private static final String PROPERTY_SOURCE_NAME = "server.ports";
        private final ConfigurableApplicationContext applicationContext;

        Listener(ConfigurableApplicationContext applicationContext) {
            this.applicationContext = applicationContext;
        }

        @Override
        public void onApplicationEvent(RSocketServerInitializedEvent event2) {
            if (event2.getServer().address() != null) {
                this.setPortProperty(this.applicationContext, event2.getServer().address().getPort());
            }
        }

        private void setPortProperty(ApplicationContext context, int port) {
            if (context instanceof ConfigurableApplicationContext) {
                ConfigurableApplicationContext configurableContext = (ConfigurableApplicationContext)context;
                this.setPortProperty(configurableContext.getEnvironment(), port);
            }
            if (context.getParent() != null) {
                this.setPortProperty(context.getParent(), port);
            }
        }

        private void setPortProperty(ConfigurableEnvironment environment2, int port) {
            MutablePropertySources sources = environment2.getPropertySources();
            MapPropertySource source2 = sources.get(PROPERTY_SOURCE_NAME);
            if (source2 == null) {
                source2 = new MapPropertySource(PROPERTY_SOURCE_NAME, (Map<String, Object>)new HashMap<String, Object>());
                sources.addFirst(source2);
            }
            this.setPortProperty(port, source2);
        }

        private void setPortProperty(int port, PropertySource<?> source2) {
            ((Map)source2.getSource()).put(PROPERTY_NAME, port);
        }
    }
}

