/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.origin;

import java.io.IOException;
import org.springframework.boot.origin.JarUri;
import org.springframework.boot.origin.Origin;
import org.springframework.boot.origin.OriginTrackedResource;
import org.springframework.core.io.ClassPathResource;
import org.springframework.core.io.Resource;
import org.springframework.util.ObjectUtils;

public class TextResourceOrigin
implements Origin {
    private final Resource resource;
    private final Location location;

    public TextResourceOrigin(Resource resource, Location location) {
        this.resource = resource;
        this.location = location;
    }

    public Resource getResource() {
        return this.resource;
    }

    public Location getLocation() {
        return this.location;
    }

    @Override
    public Origin getParent() {
        return Origin.from(this.resource);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (obj instanceof TextResourceOrigin) {
            TextResourceOrigin other = (TextResourceOrigin)obj;
            boolean result2 = true;
            result2 = result2 && ObjectUtils.nullSafeEquals(this.resource, other.resource);
            result2 = result2 && ObjectUtils.nullSafeEquals(this.location, other.location);
            return result2;
        }
        return super.equals(obj);
    }

    public int hashCode() {
        int result2 = 1;
        result2 = 31 * result2 + ObjectUtils.nullSafeHashCode(this.resource);
        result2 = 31 * result2 + ObjectUtils.nullSafeHashCode(this.location);
        return result2;
    }

    public String toString() {
        StringBuilder result2 = new StringBuilder();
        result2.append(this.getResourceDescription(this.resource));
        if (this.location != null) {
            result2.append(" - ").append(this.location);
        }
        return result2.toString();
    }

    private String getResourceDescription(Resource resource) {
        if (resource instanceof OriginTrackedResource) {
            OriginTrackedResource originTrackedResource = (OriginTrackedResource)resource;
            return this.getResourceDescription(originTrackedResource.getResource());
        }
        if (resource == null) {
            return "unknown resource [?]";
        }
        if (resource instanceof ClassPathResource) {
            ClassPathResource classPathResource = (ClassPathResource)resource;
            return this.getResourceDescription(classPathResource);
        }
        return resource.getDescription();
    }

    private String getResourceDescription(ClassPathResource resource) {
        try {
            JarUri jarUri = JarUri.from(resource.getURI());
            if (jarUri != null) {
                return jarUri.getDescription(resource.getDescription());
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return resource.getDescription();
    }

    public static final class Location {
        private final int line;
        private final int column;

        public Location(int line, int column2) {
            this.line = line;
            this.column = column2;
        }

        public int getLine() {
            return this.line;
        }

        public int getColumn() {
            return this.column;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null || this.getClass() != obj.getClass()) {
                return false;
            }
            Location other = (Location)obj;
            boolean result2 = true;
            result2 = result2 && this.line == other.line;
            result2 = result2 && this.column == other.column;
            return result2;
        }

        public int hashCode() {
            return 31 * this.line + this.column;
        }

        public String toString() {
            return this.line + 1 + ":" + (this.column + 1);
        }
    }
}

