/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.origin;

import org.springframework.boot.origin.Origin;
import org.springframework.boot.origin.OriginLookup;
import org.springframework.boot.origin.OriginProvider;
import org.springframework.core.env.PropertySource;
import org.springframework.util.Assert;

public class PropertySourceOrigin
implements Origin,
OriginProvider {
    private final PropertySource<?> propertySource;
    private final String propertyName;
    private final Origin origin;

    public PropertySourceOrigin(PropertySource<?> propertySource, String propertyName) {
        this(propertySource, propertyName, null);
    }

    public PropertySourceOrigin(PropertySource<?> propertySource, String propertyName, Origin origin) {
        Assert.notNull(propertySource, "PropertySource must not be null");
        Assert.hasLength(propertyName, "PropertyName must not be empty");
        this.propertySource = propertySource;
        this.propertyName = propertyName;
        this.origin = origin;
    }

    public PropertySource<?> getPropertySource() {
        return this.propertySource;
    }

    public String getPropertyName() {
        return this.propertyName;
    }

    @Override
    public Origin getOrigin() {
        return this.origin;
    }

    @Override
    public Origin getParent() {
        return this.origin != null ? this.origin.getParent() : null;
    }

    public String toString() {
        return this.origin != null ? this.origin.toString() : "\"" + this.propertyName + "\" from property source \"" + this.propertySource.getName() + "\"";
    }

    public static Origin get(PropertySource<?> propertySource, String name2) {
        Origin origin = OriginLookup.getOrigin(propertySource, name2);
        return origin instanceof PropertySourceOrigin ? origin : new PropertySourceOrigin(propertySource, name2, origin);
    }
}

