/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.origin;

import org.springframework.boot.origin.Origin;
import org.springframework.boot.origin.OriginProvider;
import org.springframework.util.ObjectUtils;

public class OriginTrackedValue
implements OriginProvider {
    private final Object value;
    private final Origin origin;

    private OriginTrackedValue(Object value2, Origin origin) {
        this.value = value2;
        this.origin = origin;
    }

    public Object getValue() {
        return this.value;
    }

    @Override
    public Origin getOrigin() {
        return this.origin;
    }

    public boolean equals(Object obj) {
        if (obj == null || obj.getClass() != this.getClass()) {
            return false;
        }
        return ObjectUtils.nullSafeEquals(this.value, ((OriginTrackedValue)obj).value);
    }

    public int hashCode() {
        return ObjectUtils.nullSafeHashCode(this.value);
    }

    public String toString() {
        return this.value != null ? this.value.toString() : null;
    }

    public static OriginTrackedValue of(Object value2) {
        return OriginTrackedValue.of(value2, null);
    }

    public static OriginTrackedValue of(Object value2, Origin origin) {
        if (value2 == null) {
            return null;
        }
        if (value2 instanceof CharSequence) {
            CharSequence charSequence = (CharSequence)value2;
            return new OriginTrackedCharSequence(charSequence, origin);
        }
        return new OriginTrackedValue(value2, origin);
    }

    private static class OriginTrackedCharSequence
    extends OriginTrackedValue
    implements CharSequence {
        OriginTrackedCharSequence(CharSequence value2, Origin origin) {
            super(value2, origin);
        }

        @Override
        public int length() {
            return this.getValue().length();
        }

        @Override
        public char charAt(int index2) {
            return this.getValue().charAt(index2);
        }

        @Override
        public CharSequence subSequence(int start2, int end2) {
            return this.getValue().subSequence(start2, end2);
        }

        @Override
        public CharSequence getValue() {
            return (CharSequence)super.getValue();
        }
    }
}

