/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.logging.logback;

import ch.qos.logback.classic.Level;
import ch.qos.logback.classic.LoggerContext;
import ch.qos.logback.classic.spi.ILoggingEvent;
import ch.qos.logback.core.Appender;
import ch.qos.logback.core.pattern.Converter;
import ch.qos.logback.core.spi.LifeCycle;
import ch.qos.logback.core.status.InfoStatus;
import org.springframework.boot.logging.logback.LogbackConfigurator;

class DebugLogbackConfigurator
extends LogbackConfigurator {
    DebugLogbackConfigurator(LoggerContext context) {
        super(context);
    }

    @Override
    public void conversionRule(String conversionWord, Class<? extends Converter> converterClass) {
        this.info("Adding conversion rule of type '" + converterClass.getName() + "' for word '" + conversionWord + "'");
        super.conversionRule(conversionWord, converterClass);
    }

    @Override
    public void appender(String name2, Appender<?> appender) {
        this.info("Adding appender '" + appender + "' named '" + name2 + "'");
        super.appender(name2, appender);
    }

    @Override
    public void logger(String name2, Level level2, boolean additive, Appender<ILoggingEvent> appender) {
        this.info("Configuring logger '" + name2 + "' with level '" + level2 + "'. Additive: " + additive);
        if (appender != null) {
            this.info("Adding appender '" + appender + "' to logger '" + name2 + "'");
        }
        super.logger(name2, level2, additive, appender);
    }

    @Override
    public void start(LifeCycle lifeCycle) {
        this.info("Starting '" + lifeCycle + "'");
        super.start(lifeCycle);
    }

    private void info(String message2) {
        this.getContext().getStatusManager().add(new InfoStatus(message2, this));
    }
}

