/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.logging.log4j2;

import org.apache.logging.log4j.core.LogEvent;
import org.apache.logging.log4j.core.LoggerContext;
import org.apache.logging.log4j.core.config.LoggerContextAware;
import org.apache.logging.log4j.core.config.plugins.Plugin;
import org.apache.logging.log4j.core.lookup.StrLookup;
import org.springframework.boot.logging.log4j2.Log4J2LoggingSystem;
import org.springframework.core.env.Environment;
import org.springframework.util.Assert;

@Plugin(name="spring", category="Lookup")
class SpringEnvironmentLookup
implements LoggerContextAware,
StrLookup {
    private volatile Environment environment;

    SpringEnvironmentLookup() {
    }

    public String lookup(LogEvent event2, String key2) {
        return this.lookup(key2);
    }

    public String lookup(String key2) {
        Assert.state(this.environment != null, "Unable to obtain Spring Environment from LoggerContext");
        return this.environment.getProperty(key2);
    }

    public void setLoggerContext(LoggerContext loggerContext) {
        this.environment = Log4J2LoggingSystem.getEnvironment(loggerContext);
    }
}

