/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.logging.log4j2;

import org.apache.logging.log4j.core.LogEvent;
import org.apache.logging.log4j.core.config.Configuration;
import org.apache.logging.log4j.core.config.plugins.Plugin;
import org.apache.logging.log4j.core.pattern.ConverterKeys;
import org.apache.logging.log4j.core.pattern.ExtendedThrowablePatternConverter;
import org.apache.logging.log4j.core.pattern.ThrowablePatternConverter;

@Plugin(name="ExtendedWhitespaceThrowablePatternConverter", category="Converter")
@ConverterKeys(value={"xwEx", "xwThrowable", "xwException"})
public final class ExtendedWhitespaceThrowablePatternConverter
extends ThrowablePatternConverter {
    private final ExtendedThrowablePatternConverter delegate;

    private ExtendedWhitespaceThrowablePatternConverter(Configuration configuration, String[] options2) {
        super("WhitespaceExtendedThrowable", "throwable", options2, configuration);
        this.delegate = ExtendedThrowablePatternConverter.newInstance((Configuration)configuration, (String[])options2);
    }

    public void format(LogEvent event2, StringBuilder buffer) {
        if (event2.getThrown() != null) {
            buffer.append(this.options.getSeparator());
            this.delegate.format(event2, buffer);
            buffer.append(this.options.getSeparator());
        }
    }

    public static ExtendedWhitespaceThrowablePatternConverter newInstance(Configuration configuration, String[] options2) {
        return new ExtendedWhitespaceThrowablePatternConverter(configuration, options2);
    }
}

