/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.logging;

import java.io.File;
import java.util.Properties;
import org.springframework.boot.logging.LoggingSystemProperty;
import org.springframework.core.env.PropertyResolver;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

public class LogFile {
    public static final String FILE_NAME_PROPERTY = "logging.file.name";
    public static final String FILE_PATH_PROPERTY = "logging.file.path";
    private final String file;
    private final String path;

    LogFile(String file2) {
        this(file2, null);
    }

    LogFile(String file2, String path2) {
        Assert.isTrue(StringUtils.hasLength(file2) || StringUtils.hasLength(path2), "File or Path must not be empty");
        this.file = file2;
        this.path = path2;
    }

    public void applyToSystemProperties() {
        this.applyTo(System.getProperties());
    }

    public void applyTo(Properties properties) {
        this.put(properties, LoggingSystemProperty.LOG_PATH, this.path);
        this.put(properties, LoggingSystemProperty.LOG_FILE, this.toString());
    }

    private void put(Properties properties, LoggingSystemProperty property, String value2) {
        if (StringUtils.hasLength(value2)) {
            properties.put(property.getEnvironmentVariableName(), value2);
        }
    }

    public String toString() {
        if (StringUtils.hasLength(this.file)) {
            return this.file;
        }
        return new File(this.path, "spring.log").getPath();
    }

    public static LogFile get(PropertyResolver propertyResolver) {
        String file2 = propertyResolver.getProperty(FILE_NAME_PROPERTY);
        String path2 = propertyResolver.getProperty(FILE_PATH_PROPERTY);
        if (StringUtils.hasLength(file2) || StringUtils.hasLength(path2)) {
            return new LogFile(file2, path2);
        }
        return null;
    }
}

