/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.logging;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.function.Supplier;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.boot.logging.LogLevel;
import org.springframework.util.Assert;

public class DeferredLog
implements Log {
    private Log destination;
    private final Supplier<Log> destinationSupplier;
    private final Lines lines;

    public DeferredLog() {
        this.destinationSupplier = null;
        this.lines = new Lines();
    }

    DeferredLog(Supplier<Log> destination, Lines lines2) {
        Assert.notNull(destination, "Destination must not be null");
        this.destinationSupplier = destination;
        this.lines = lines2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isTraceEnabled() {
        Lines lines2 = this.lines;
        synchronized (lines2) {
            return this.destination == null || this.destination.isTraceEnabled();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isDebugEnabled() {
        Lines lines2 = this.lines;
        synchronized (lines2) {
            return this.destination == null || this.destination.isDebugEnabled();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isInfoEnabled() {
        Lines lines2 = this.lines;
        synchronized (lines2) {
            return this.destination == null || this.destination.isInfoEnabled();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isWarnEnabled() {
        Lines lines2 = this.lines;
        synchronized (lines2) {
            return this.destination == null || this.destination.isWarnEnabled();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isErrorEnabled() {
        Lines lines2 = this.lines;
        synchronized (lines2) {
            return this.destination == null || this.destination.isErrorEnabled();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isFatalEnabled() {
        Lines lines2 = this.lines;
        synchronized (lines2) {
            return this.destination == null || this.destination.isFatalEnabled();
        }
    }

    @Override
    public void trace(Object message2) {
        this.log(LogLevel.TRACE, message2, null);
    }

    @Override
    public void trace(Object message2, Throwable t) {
        this.log(LogLevel.TRACE, message2, t);
    }

    @Override
    public void debug(Object message2) {
        this.log(LogLevel.DEBUG, message2, null);
    }

    @Override
    public void debug(Object message2, Throwable t) {
        this.log(LogLevel.DEBUG, message2, t);
    }

    @Override
    public void info(Object message2) {
        this.log(LogLevel.INFO, message2, null);
    }

    @Override
    public void info(Object message2, Throwable t) {
        this.log(LogLevel.INFO, message2, t);
    }

    @Override
    public void warn(Object message2) {
        this.log(LogLevel.WARN, message2, null);
    }

    @Override
    public void warn(Object message2, Throwable t) {
        this.log(LogLevel.WARN, message2, t);
    }

    @Override
    public void error(Object message2) {
        this.log(LogLevel.ERROR, message2, null);
    }

    @Override
    public void error(Object message2, Throwable t) {
        this.log(LogLevel.ERROR, message2, t);
    }

    @Override
    public void fatal(Object message2) {
        this.log(LogLevel.FATAL, message2, null);
    }

    @Override
    public void fatal(Object message2, Throwable t) {
        this.log(LogLevel.FATAL, message2, t);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void log(LogLevel level2, Object message2, Throwable t) {
        Lines lines2 = this.lines;
        synchronized (lines2) {
            if (this.destination != null) {
                DeferredLog.logTo(this.destination, level2, message2, t);
            } else {
                this.lines.add(this.destinationSupplier, level2, message2, t);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void switchOver() {
        Lines lines2 = this.lines;
        synchronized (lines2) {
            this.destination = this.destinationSupplier.get();
        }
    }

    public void switchTo(Class<?> destination) {
        this.switchTo(LogFactory.getLog(destination));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void switchTo(Log destination) {
        Lines lines2 = this.lines;
        synchronized (lines2) {
            this.replayTo(destination);
            this.destination = destination;
        }
    }

    public void replayTo(Class<?> destination) {
        this.replayTo(LogFactory.getLog(destination));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void replayTo(Log destination) {
        Lines lines2 = this.lines;
        synchronized (lines2) {
            for (Line line : this.lines) {
                DeferredLog.logTo(destination, line.getLevel(), line.getMessage(), line.getThrowable());
            }
            this.lines.clear();
        }
    }

    public static Log replay(Log source2, Class<?> destination) {
        return DeferredLog.replay(source2, LogFactory.getLog(destination));
    }

    public static Log replay(Log source2, Log destination) {
        if (source2 instanceof DeferredLog) {
            DeferredLog deferredLog = (DeferredLog)source2;
            deferredLog.replayTo(destination);
        }
        return destination;
    }

    static void logTo(Log log3, LogLevel level2, Object message2, Throwable throwable) {
        switch (level2) {
            case TRACE: {
                log3.trace(message2, throwable);
                break;
            }
            case DEBUG: {
                log3.debug(message2, throwable);
                break;
            }
            case INFO: {
                log3.info(message2, throwable);
                break;
            }
            case WARN: {
                log3.warn(message2, throwable);
                break;
            }
            case ERROR: {
                log3.error(message2, throwable);
                break;
            }
            case FATAL: {
                log3.fatal(message2, throwable);
            }
        }
    }

    static class Lines
    implements Iterable<Line> {
        private final List<Line> lines = new ArrayList<Line>();

        Lines() {
        }

        void add(Supplier<Log> destinationSupplier, LogLevel level2, Object message2, Throwable throwable) {
            this.lines.add(new Line(destinationSupplier, level2, message2, throwable));
        }

        void clear() {
            this.lines.clear();
        }

        @Override
        public Iterator<Line> iterator() {
            return this.lines.iterator();
        }
    }

    static class Line {
        private final Supplier<Log> destinationSupplier;
        private final LogLevel level;
        private final Object message;
        private final Throwable throwable;

        Line(Supplier<Log> destinationSupplier, LogLevel level2, Object message2, Throwable throwable) {
            this.destinationSupplier = destinationSupplier;
            this.level = level2;
            this.message = message2;
            this.throwable = throwable;
        }

        Log getDestination() {
            return this.destinationSupplier.get();
        }

        LogLevel getLevel() {
            return this.level;
        }

        Object getMessage() {
            return this.message;
        }

        Throwable getThrowable() {
            return this.throwable;
        }
    }
}

