/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.logging;

import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.function.Predicate;
import java.util.function.UnaryOperator;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

public final class CorrelationIdFormatter {
    public static final CorrelationIdFormatter DEFAULT = CorrelationIdFormatter.of("traceId(32),spanId(16)");
    private final List<Part> parts;
    private final String blank;

    private CorrelationIdFormatter(List<Part> parts) {
        this.parts = parts;
        this.blank = String.format("[%s] ", parts.stream().map(Part::blank).collect(Collectors.joining(" ")));
    }

    public String format(UnaryOperator<String> resolver) {
        StringBuilder result2 = new StringBuilder();
        this.formatTo(resolver, result2);
        return result2.toString();
    }

    public void formatTo(UnaryOperator<String> resolver, Appendable appendable) {
        Predicate<Part> canResolve = part -> StringUtils.hasLength((String)resolver.apply(part.name()));
        try {
            if (this.parts.stream().anyMatch(canResolve)) {
                appendable.append('[');
                Iterator<Part> iterator = this.parts.iterator();
                while (iterator.hasNext()) {
                    appendable.append(iterator.next().resolve(resolver));
                    if (!iterator.hasNext()) continue;
                    appendable.append('-');
                }
                appendable.append("] ");
            } else {
                appendable.append(this.blank);
            }
        }
        catch (IOException ex) {
            throw new UncheckedIOException(ex);
        }
    }

    public String toString() {
        return this.parts.stream().map(Part::toString).collect(Collectors.joining(","));
    }

    public static CorrelationIdFormatter of(String spec) {
        try {
            return !StringUtils.hasText(spec) ? DEFAULT : CorrelationIdFormatter.of(List.of(spec.split(",")));
        }
        catch (Exception ex) {
            throw new IllegalStateException("Unable to parse correlation formatter spec '%s'".formatted(spec), ex);
        }
    }

    public static CorrelationIdFormatter of(String[] spec) {
        return CorrelationIdFormatter.of(spec != null ? List.of(spec) : Collections.emptyList());
    }

    public static CorrelationIdFormatter of(Collection<String> spec) {
        if (CollectionUtils.isEmpty(spec)) {
            return DEFAULT;
        }
        List<Part> parts = spec.stream().map(Part::of).toList();
        return new CorrelationIdFormatter(parts);
    }

    record Part(String name, int length) {
        private static final Pattern pattern = Pattern.compile("^(.+?)\\((\\d+)\\)$");

        String resolve(UnaryOperator<String> resolver) {
            String resolved = (String)resolver.apply(this.name());
            if (resolved == null) {
                return this.blank();
            }
            int padding = this.length() - resolved.length();
            return padding <= 0 ? resolved : resolved + " ".repeat(padding);
        }

        String blank() {
            return " ".repeat(this.length);
        }

        @Override
        public String toString() {
            return "%s(%s)".formatted(this.name(), this.length());
        }

        static Part of(String part) {
            Matcher matcher = pattern.matcher(part.trim());
            Assert.state(matcher.matches(), () -> "Invalid specification part '%s'".formatted(part));
            String name2 = matcher.group(1);
            int length2 = Integer.parseInt(matcher.group(2));
            return new Part(name2, length2);
        }
    }
}

