/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.liquibase;

import liquibase.exception.ChangeLogParseException;
import org.springframework.boot.diagnostics.AbstractFailureAnalyzer;
import org.springframework.boot.diagnostics.FailureAnalysis;

class LiquibaseChangelogMissingFailureAnalyzer
extends AbstractFailureAnalyzer<ChangeLogParseException> {
    private static final String MESSAGE_SUFFIX = " does not exist";

    LiquibaseChangelogMissingFailureAnalyzer() {
    }

    @Override
    protected FailureAnalysis analyze(Throwable rootFailure, ChangeLogParseException cause2) {
        if (cause2.getMessage().endsWith(MESSAGE_SUFFIX)) {
            String changelogPath = this.extractChangelogPath(cause2);
            return new FailureAnalysis(this.getDescription(changelogPath), "Make sure a Liquibase changelog is present at the configured path.", (Throwable)cause2);
        }
        return null;
    }

    private String extractChangelogPath(ChangeLogParseException cause2) {
        return cause2.getMessage().substring(0, cause2.getMessage().length() - MESSAGE_SUFFIX.length());
    }

    private String getDescription(String changelogPath) {
        return "Liquibase failed to start because no changelog could be found at '" + changelogPath + "'.";
    }
}

