/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.json;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.springframework.boot.json.AbstractJsonParser;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

public class BasicJsonParser
extends AbstractJsonParser {
    private static final int MAX_DEPTH = 1000;

    @Override
    public Map<String, Object> parseMap(String json) {
        return this.tryParse(() -> this.parseMap(json, jsonToParse -> this.parseMapInternal(0, (String)jsonToParse)), Exception.class);
    }

    @Override
    public List<Object> parseList(String json) {
        return this.tryParse(() -> this.parseList(json, jsonToParse -> this.parseListInternal(0, (String)jsonToParse)), Exception.class);
    }

    private List<Object> parseListInternal(int nesting2, String json) {
        ArrayList<Object> list2 = new ArrayList<Object>();
        json = BasicJsonParser.trimEdges(json, '[', ']').trim();
        for (String value2 : this.tokenize(json)) {
            list2.add(this.parseInternal(nesting2 + 1, value2));
        }
        return list2;
    }

    private Object parseInternal(int nesting2, String json) {
        if (nesting2 > 1000) {
            throw new IllegalStateException("JSON is too deeply nested");
        }
        if (json.startsWith("[")) {
            return this.parseListInternal(nesting2 + 1, json);
        }
        if (json.startsWith("{")) {
            return this.parseMapInternal(nesting2 + 1, json);
        }
        if (json.startsWith("\"")) {
            return BasicJsonParser.trimEdges(json, '\"', '\"');
        }
        return this.parseNumber(json);
    }

    private Map<String, Object> parseMapInternal(int nesting2, String json) {
        LinkedHashMap<String, Object> map2 = new LinkedHashMap<String, Object>();
        json = BasicJsonParser.trimEdges(json, '{', '}').trim();
        for (String pair : this.tokenize(json)) {
            String[] values2 = StringUtils.trimArrayElements(StringUtils.split(pair, ":"));
            Assert.state(values2[0].startsWith("\"") && values2[0].endsWith("\""), "Expecting double-quotes around field names");
            String key2 = BasicJsonParser.trimEdges(values2[0], '\"', '\"');
            Object value2 = this.parseInternal(nesting2, values2[1]);
            map2.put(key2, value2);
        }
        return map2;
    }

    private Object parseNumber(String json) {
        try {
            return Long.valueOf(json);
        }
        catch (NumberFormatException ex) {
            try {
                return Double.valueOf(json);
            }
            catch (NumberFormatException ex2) {
                return json;
            }
        }
    }

    private static String trimTrailingCharacter(String string2, char c) {
        if (!string2.isEmpty() && string2.charAt(string2.length() - 1) == c) {
            return string2.substring(0, string2.length() - 1);
        }
        return string2;
    }

    private static String trimLeadingCharacter(String string2, char c) {
        if (!string2.isEmpty() && string2.charAt(0) == c) {
            return string2.substring(1);
        }
        return string2;
    }

    private static String trimEdges(String string2, char leadingChar, char trailingChar) {
        return BasicJsonParser.trimTrailingCharacter(BasicJsonParser.trimLeadingCharacter(string2, leadingChar), trailingChar);
    }

    private List<String> tokenize(String json) {
        ArrayList<String> list2 = new ArrayList<String>();
        int index2 = 0;
        int inObject = 0;
        int inList = 0;
        boolean inValue = false;
        boolean inEscape = false;
        StringBuilder build = new StringBuilder();
        while (index2 < json.length()) {
            char current2 = json.charAt(index2);
            if (inEscape) {
                build.append(current2);
                ++index2;
                inEscape = false;
                continue;
            }
            if (current2 == '{') {
                ++inObject;
            }
            if (current2 == '}') {
                --inObject;
            }
            if (current2 == '[') {
                ++inList;
            }
            if (current2 == ']') {
                --inList;
            }
            if (current2 == '\"') {
                boolean bl = inValue = !inValue;
            }
            if (current2 == ',' && inObject == 0 && inList == 0 && !inValue) {
                list2.add(build.toString());
                build.setLength(0);
            } else if (current2 == '\\') {
                inEscape = true;
            } else {
                build.append(current2);
            }
            ++index2;
        }
        if (!build.isEmpty()) {
            list2.add(build.toString().trim());
        }
        return list2;
    }
}

