/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.jdbc;

import java.sql.Wrapper;
import javax.sql.DataSource;
import org.springframework.aop.framework.AopProxyUtils;
import org.springframework.aop.support.AopUtils;
import org.springframework.jdbc.datasource.DelegatingDataSource;
import org.springframework.util.ClassUtils;

public final class DataSourceUnwrapper {
    private static final boolean DELEGATING_DATA_SOURCE_PRESENT = ClassUtils.isPresent("org.springframework.jdbc.datasource.DelegatingDataSource", DataSourceUnwrapper.class.getClassLoader());

    private DataSourceUnwrapper() {
    }

    public static <I, T extends I> T unwrap(DataSource dataSource, Class<I> unwrapInterface, Class<T> target2) {
        Object proxyTarget;
        DataSource targetDataSource;
        if (target2.isInstance(dataSource)) {
            return target2.cast(dataSource);
        }
        I unwrapped = DataSourceUnwrapper.safeUnwrap(dataSource, unwrapInterface);
        if (unwrapped != null && unwrapInterface.isAssignableFrom(target2)) {
            return target2.cast(unwrapped);
        }
        if (DELEGATING_DATA_SOURCE_PRESENT && (targetDataSource = DelegatingDataSourceUnwrapper.getTargetDataSource(dataSource)) != null) {
            return DataSourceUnwrapper.unwrap(targetDataSource, unwrapInterface, target2);
        }
        if (AopUtils.isAopProxy(dataSource) && (proxyTarget = AopProxyUtils.getSingletonTarget(dataSource)) instanceof DataSource) {
            DataSource proxyDataSource = (DataSource)proxyTarget;
            return DataSourceUnwrapper.unwrap(proxyDataSource, unwrapInterface, target2);
        }
        return null;
    }

    public static <T> T unwrap(DataSource dataSource, Class<T> target2) {
        return DataSourceUnwrapper.unwrap(dataSource, target2, target2);
    }

    private static <S> S safeUnwrap(Wrapper wrapper, Class<S> target2) {
        try {
            if (target2.isInterface() && wrapper.isWrapperFor(target2)) {
                return wrapper.unwrap(target2);
            }
        }
        catch (Exception exception2) {
            // empty catch block
        }
        return null;
    }

    private static final class DelegatingDataSourceUnwrapper {
        private DelegatingDataSourceUnwrapper() {
        }

        private static DataSource getTargetDataSource(DataSource dataSource) {
            if (dataSource instanceof DelegatingDataSource) {
                DelegatingDataSource delegatingDataSource = (DelegatingDataSource)dataSource;
                return delegatingDataSource.getTargetDataSource();
            }
            return null;
        }
    }
}

