/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.jdbc;

import com.mchange.v2.c3p0.AbstractComboPooledDataSource;
import com.mchange.v2.c3p0.ComboPooledDataSource;
import com.zaxxer.hikari.HikariConfig;
import com.zaxxer.hikari.HikariDataSource;
import java.beans.PropertyVetoException;
import java.lang.reflect.Method;
import java.sql.SQLException;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.function.Supplier;
import oracle.jdbc.datasource.OracleCommonDataSource;
import oracle.jdbc.datasource.OracleDataSource;
import oracle.ucp.jdbc.PoolDataSource;
import oracle.ucp.jdbc.PoolDataSourceImpl;
import org.apache.commons.dbcp2.BasicDataSource;
import org.apache.commons.dbcp2.DataSourceMXBean;
import org.apache.tomcat.jdbc.pool.DataSource;
import org.apache.tomcat.jdbc.pool.DataSourceProxy;
import org.h2.jdbcx.JdbcDataSource;
import org.postgresql.ds.PGSimpleDataSource;
import org.postgresql.ds.common.BaseDataSource;
import org.springframework.beans.BeanUtils;
import org.springframework.boot.jdbc.DatabaseDriver;
import org.springframework.boot.jdbc.UnsupportedDataSourcePropertyException;
import org.springframework.core.ResolvableType;
import org.springframework.jdbc.datasource.AbstractDriverBasedDataSource;
import org.springframework.jdbc.datasource.SimpleDriverDataSource;
import org.springframework.jdbc.datasource.embedded.EmbeddedDatabase;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;
import org.springframework.util.ReflectionUtils;
import org.springframework.util.StringUtils;

public final class DataSourceBuilder<T extends javax.sql.DataSource> {
    private final ClassLoader classLoader;
    private final Map<DataSourceProperty, String> values = new HashMap<DataSourceProperty, String>();
    private Class<T> type;
    private final javax.sql.DataSource deriveFrom;

    private DataSourceBuilder(ClassLoader classLoader) {
        this.classLoader = classLoader;
        this.deriveFrom = null;
    }

    private DataSourceBuilder(T deriveFrom) {
        Assert.notNull(deriveFrom, "DataSource must not be null");
        this.classLoader = deriveFrom.getClass().getClassLoader();
        this.type = deriveFrom.getClass();
        this.deriveFrom = deriveFrom;
    }

    public <D extends javax.sql.DataSource> DataSourceBuilder<D> type(Class<D> type2) {
        this.type = type2;
        return this;
    }

    public DataSourceBuilder<T> url(String url) {
        this.set(DataSourceProperty.URL, url);
        return this;
    }

    public DataSourceBuilder<T> driverClassName(String driverClassName) {
        this.set(DataSourceProperty.DRIVER_CLASS_NAME, driverClassName);
        return this;
    }

    public DataSourceBuilder<T> username(String username) {
        this.set(DataSourceProperty.USERNAME, username);
        return this;
    }

    public DataSourceBuilder<T> password(String password) {
        this.set(DataSourceProperty.PASSWORD, password);
        return this;
    }

    private void set(DataSourceProperty property, String value2) {
        this.values.put(property, value2);
    }

    public T build() {
        DataSourceProperties<javax.sql.DataSource> properties = DataSourceProperties.forType(this.classLoader, this.type);
        DataSourceProperties<javax.sql.DataSource> deriveFromProperties = this.getDeriveFromProperties();
        Class<T> instanceType = this.type != null ? this.type : properties.getDataSourceInstanceType();
        javax.sql.DataSource dataSource = (javax.sql.DataSource)BeanUtils.instantiateClass(instanceType);
        HashSet<DataSourceProperty> applied = new HashSet<DataSourceProperty>();
        for (DataSourceProperty property : DataSourceProperty.values()) {
            String value2 = this.values.get((Object)property);
            if (value2 == null && deriveFromProperties != null && properties.canSet(property)) {
                value2 = deriveFromProperties.get(this.deriveFrom, property);
            }
            if (value2 == null) continue;
            properties.set(dataSource, property, value2);
            applied.add(property);
        }
        if (!applied.contains((Object)DataSourceProperty.DRIVER_CLASS_NAME) && properties.canSet(DataSourceProperty.DRIVER_CLASS_NAME) && this.values.containsKey((Object)DataSourceProperty.URL)) {
            String url = this.values.get((Object)DataSourceProperty.URL);
            DatabaseDriver driver = DatabaseDriver.fromJdbcUrl(url);
            properties.set(dataSource, DataSourceProperty.DRIVER_CLASS_NAME, driver.getDriverClassName());
        }
        return (T)dataSource;
    }

    private DataSourceProperties<javax.sql.DataSource> getDeriveFromProperties() {
        if (this.deriveFrom == null) {
            return null;
        }
        return DataSourceProperties.forType(this.classLoader, this.deriveFrom.getClass());
    }

    public static DataSourceBuilder<?> create() {
        return DataSourceBuilder.create(null);
    }

    public static DataSourceBuilder<?> create(ClassLoader classLoader) {
        return new DataSourceBuilder(classLoader);
    }

    public static DataSourceBuilder<?> derivedFrom(javax.sql.DataSource dataSource) {
        if (dataSource instanceof EmbeddedDatabase) {
            try {
                dataSource = dataSource.unwrap(javax.sql.DataSource.class);
            }
            catch (SQLException ex) {
                throw new IllegalStateException("Unable to unwrap embedded database", ex);
            }
        }
        return new DataSourceBuilder<javax.sql.DataSource>(DataSourceBuilder.unwrap(dataSource));
    }

    private static javax.sql.DataSource unwrap(javax.sql.DataSource dataSource) {
        try {
            while (dataSource.isWrapperFor(javax.sql.DataSource.class)) {
                javax.sql.DataSource unwrapped = dataSource.unwrap(javax.sql.DataSource.class);
                if (unwrapped == dataSource) {
                    return unwrapped;
                }
                dataSource = unwrapped;
            }
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        return dataSource;
    }

    public static Class<? extends javax.sql.DataSource> findType(ClassLoader classLoader) {
        MappedDataSourceProperties mappings = MappedDataSourceProperties.forType(classLoader, null);
        return mappings != null ? mappings.getDataSourceInstanceType() : null;
    }

    private static enum DataSourceProperty {
        URL(false, "url", "URL"),
        DRIVER_CLASS_NAME(true, "driverClassName"),
        USERNAME(false, "username", "user"),
        PASSWORD(false, "password");

        private final boolean optional;
        private final String[] names;

        private DataSourceProperty(boolean optional, String ... names2) {
            this.optional = optional;
            this.names = names2;
        }

        boolean isOptional() {
            return this.optional;
        }

        public String toString() {
            return this.names[0];
        }

        Method findSetter(Class<?> type2) {
            return this.findMethod("set", type2, String.class);
        }

        Method findGetter(Class<?> type2) {
            return this.findMethod("get", type2, new Class[0]);
        }

        private Method findMethod(String prefix, Class<?> type2, Class<?> ... paramTypes) {
            for (String name2 : this.names) {
                String candidate = prefix + StringUtils.capitalize(name2);
                Method method2 = ReflectionUtils.findMethod(type2, candidate, paramTypes);
                if (method2 == null) continue;
                return method2;
            }
            return null;
        }
    }

    private static interface DataSourceProperties<T extends javax.sql.DataSource> {
        public Class<? extends T> getDataSourceInstanceType();

        public boolean canSet(DataSourceProperty var1);

        public void set(T var1, DataSourceProperty var2, String var3);

        public String get(T var1, DataSourceProperty var2);

        public static <T extends javax.sql.DataSource> DataSourceProperties<T> forType(ClassLoader classLoader, Class<T> type2) {
            MappedDataSourceProperties<T> mapped = MappedDataSourceProperties.forType(classLoader, type2);
            return mapped != null ? mapped : new ReflectionDataSourceProperties<T>(type2);
        }
    }

    private static class MappedDataSourceProperties<T extends javax.sql.DataSource>
    implements DataSourceProperties<T> {
        private final Map<DataSourceProperty, MappedDataSourceProperty<T, ?>> mappedProperties = new HashMap();
        private final Class<T> dataSourceType = ResolvableType.forClass(MappedDataSourceProperties.class, this.getClass()).resolveGeneric(new int[0]);

        MappedDataSourceProperties() {
        }

        @Override
        public Class<? extends T> getDataSourceInstanceType() {
            return this.dataSourceType;
        }

        protected void add(DataSourceProperty property, Getter<T, String> getter, Setter<T, String> setter) {
            this.add(property, String.class, getter, setter);
        }

        protected <V> void add(DataSourceProperty property, Class<V> type2, Getter<T, V> getter, Setter<T, V> setter) {
            this.mappedProperties.put(property, new MappedDataSourceProperty<T, V>(property, type2, getter, setter));
        }

        @Override
        public boolean canSet(DataSourceProperty property) {
            return this.mappedProperties.containsKey((Object)property);
        }

        @Override
        public void set(T dataSource, DataSourceProperty property, String value2) {
            MappedDataSourceProperty<T, ?> mappedProperty = this.getMapping(property);
            if (mappedProperty != null) {
                mappedProperty.set(dataSource, value2);
            }
        }

        @Override
        public String get(T dataSource, DataSourceProperty property) {
            MappedDataSourceProperty<T, ?> mappedProperty = this.getMapping(property);
            if (mappedProperty != null) {
                return mappedProperty.get(dataSource);
            }
            return null;
        }

        private MappedDataSourceProperty<T, ?> getMapping(DataSourceProperty property) {
            MappedDataSourceProperty<T, ?> mappedProperty = this.mappedProperties.get((Object)property);
            UnsupportedDataSourcePropertyException.throwIf(!property.isOptional() && mappedProperty == null, () -> "No mapping found for " + property);
            return mappedProperty;
        }

        static <T extends javax.sql.DataSource> MappedDataSourceProperties<T> forType(ClassLoader classLoader, Class<T> type2) {
            MappedDataSourceProperties<T> pooled = MappedDataSourceProperties.lookupPooled(classLoader, type2);
            if (type2 == null || pooled != null) {
                return pooled;
            }
            return MappedDataSourceProperties.lookupBasic(classLoader, type2);
        }

        private static <T extends javax.sql.DataSource> MappedDataSourceProperties<T> lookupPooled(ClassLoader classLoader, Class<T> type2) {
            MappedDataSourceProperties<T> result2 = null;
            result2 = MappedDataSourceProperties.lookup(classLoader, type2, result2, "com.zaxxer.hikari.HikariDataSource", HikariDataSourceProperties::new, new String[0]);
            result2 = MappedDataSourceProperties.lookup(classLoader, type2, result2, "org.apache.tomcat.jdbc.pool.DataSource", TomcatPoolDataSourceProperties::new, new String[0]);
            result2 = MappedDataSourceProperties.lookup(classLoader, type2, result2, "org.apache.commons.dbcp2.BasicDataSource", MappedDbcp2DataSource::new, new String[0]);
            result2 = MappedDataSourceProperties.lookup(classLoader, type2, result2, "oracle.ucp.jdbc.PoolDataSourceImpl", OraclePoolDataSourceProperties::new, "oracle.jdbc.OracleConnection");
            result2 = MappedDataSourceProperties.lookup(classLoader, type2, result2, "com.mchange.v2.c3p0.ComboPooledDataSource", ComboPooledDataSourceProperties::new, new String[0]);
            return result2;
        }

        private static <T extends javax.sql.DataSource> MappedDataSourceProperties<T> lookupBasic(ClassLoader classLoader, Class<T> dataSourceType) {
            MappedDataSourceProperties<T> result2 = null;
            result2 = MappedDataSourceProperties.lookup(classLoader, dataSourceType, result2, "org.springframework.jdbc.datasource.SimpleDriverDataSource", SimpleDataSourceProperties::new, new String[0]);
            result2 = MappedDataSourceProperties.lookup(classLoader, dataSourceType, result2, "oracle.jdbc.datasource.OracleDataSource", OracleDataSourceProperties::new, new String[0]);
            result2 = MappedDataSourceProperties.lookup(classLoader, dataSourceType, result2, "org.h2.jdbcx.JdbcDataSource", H2DataSourceProperties::new, new String[0]);
            result2 = MappedDataSourceProperties.lookup(classLoader, dataSourceType, result2, "org.postgresql.ds.PGSimpleDataSource", PostgresDataSourceProperties::new, new String[0]);
            return result2;
        }

        private static <T extends javax.sql.DataSource> MappedDataSourceProperties<T> lookup(ClassLoader classLoader, Class<T> dataSourceType, MappedDataSourceProperties<T> existing, String dataSourceClassName, Supplier<MappedDataSourceProperties<?>> propertyMappingsSupplier, String ... requiredClassNames) {
            if (existing != null || !MappedDataSourceProperties.allPresent(classLoader, dataSourceClassName, requiredClassNames)) {
                return existing;
            }
            MappedDataSourceProperties<?> propertyMappings = propertyMappingsSupplier.get();
            return dataSourceType == null || propertyMappings.getDataSourceInstanceType().isAssignableFrom(dataSourceType) ? propertyMappings : null;
        }

        private static boolean allPresent(ClassLoader classLoader, String dataSourceClassName, String[] requiredClassNames) {
            boolean result2 = ClassUtils.isPresent(dataSourceClassName, classLoader);
            for (String requiredClassName : requiredClassNames) {
                result2 = result2 && ClassUtils.isPresent(requiredClassName, classLoader);
            }
            return result2;
        }
    }

    private static class PostgresDataSourceProperties
    extends MappedDataSourceProperties<PGSimpleDataSource> {
        PostgresDataSourceProperties() {
            this.add(DataSourceProperty.URL, BaseDataSource::getUrl, BaseDataSource::setUrl);
            this.add(DataSourceProperty.USERNAME, BaseDataSource::getUser, BaseDataSource::setUser);
            this.add(DataSourceProperty.PASSWORD, BaseDataSource::getPassword, BaseDataSource::setPassword);
        }
    }

    private static class H2DataSourceProperties
    extends MappedDataSourceProperties<JdbcDataSource> {
        H2DataSourceProperties() {
            this.add(DataSourceProperty.URL, JdbcDataSource::getUrl, JdbcDataSource::setUrl);
            this.add(DataSourceProperty.USERNAME, JdbcDataSource::getUser, JdbcDataSource::setUser);
            this.add(DataSourceProperty.PASSWORD, JdbcDataSource::getPassword, JdbcDataSource::setPassword);
        }
    }

    private static class OracleDataSourceProperties
    extends MappedDataSourceProperties<OracleDataSource> {
        OracleDataSourceProperties() {
            this.add(DataSourceProperty.URL, OracleCommonDataSource::getURL, OracleCommonDataSource::setURL);
            this.add(DataSourceProperty.USERNAME, OracleCommonDataSource::getUser, OracleCommonDataSource::setUser);
            this.add(DataSourceProperty.PASSWORD, null, OracleCommonDataSource::setPassword);
        }
    }

    private static class SimpleDataSourceProperties
    extends MappedDataSourceProperties<SimpleDriverDataSource> {
        SimpleDataSourceProperties() {
            this.add(DataSourceProperty.URL, AbstractDriverBasedDataSource::getUrl, AbstractDriverBasedDataSource::setUrl);
            this.add(DataSourceProperty.DRIVER_CLASS_NAME, Class.class, dataSource -> dataSource.getDriver().getClass(), SimpleDriverDataSource::setDriverClass);
            this.add(DataSourceProperty.USERNAME, AbstractDriverBasedDataSource::getUsername, AbstractDriverBasedDataSource::setUsername);
            this.add(DataSourceProperty.PASSWORD, AbstractDriverBasedDataSource::getPassword, AbstractDriverBasedDataSource::setPassword);
        }
    }

    private static class ComboPooledDataSourceProperties
    extends MappedDataSourceProperties<ComboPooledDataSource> {
        ComboPooledDataSourceProperties() {
            this.add(DataSourceProperty.URL, AbstractComboPooledDataSource::getJdbcUrl, AbstractComboPooledDataSource::setJdbcUrl);
            this.add(DataSourceProperty.DRIVER_CLASS_NAME, AbstractComboPooledDataSource::getDriverClass, this::setDriverClass);
            this.add(DataSourceProperty.USERNAME, AbstractComboPooledDataSource::getUser, AbstractComboPooledDataSource::setUser);
            this.add(DataSourceProperty.PASSWORD, AbstractComboPooledDataSource::getPassword, AbstractComboPooledDataSource::setPassword);
        }

        private void setDriverClass(ComboPooledDataSource dataSource, String driverClass) {
            try {
                dataSource.setDriverClass(driverClass);
            }
            catch (PropertyVetoException ex) {
                throw new IllegalArgumentException(ex);
            }
        }
    }

    private static class OraclePoolDataSourceProperties
    extends MappedDataSourceProperties<PoolDataSource> {
        @Override
        public Class<? extends PoolDataSource> getDataSourceInstanceType() {
            return PoolDataSourceImpl.class;
        }

        OraclePoolDataSourceProperties() {
            this.add(DataSourceProperty.URL, PoolDataSource::getURL, PoolDataSource::setURL);
            this.add(DataSourceProperty.DRIVER_CLASS_NAME, PoolDataSource::getConnectionFactoryClassName, PoolDataSource::setConnectionFactoryClassName);
            this.add(DataSourceProperty.USERNAME, PoolDataSource::getUser, PoolDataSource::setUser);
            this.add(DataSourceProperty.PASSWORD, null, PoolDataSource::setPassword);
        }
    }

    private static class MappedDbcp2DataSource
    extends MappedDataSourceProperties<BasicDataSource> {
        MappedDbcp2DataSource() {
            this.add(DataSourceProperty.URL, BasicDataSource::getUrl, BasicDataSource::setUrl);
            this.add(DataSourceProperty.DRIVER_CLASS_NAME, BasicDataSource::getDriverClassName, BasicDataSource::setDriverClassName);
            this.add(DataSourceProperty.USERNAME, DataSourceMXBean::getUserName, BasicDataSource::setUsername);
            this.add(DataSourceProperty.PASSWORD, null, BasicDataSource::setPassword);
        }
    }

    private static class TomcatPoolDataSourceProperties
    extends MappedDataSourceProperties<DataSource> {
        TomcatPoolDataSourceProperties() {
            this.add(DataSourceProperty.URL, DataSourceProxy::getUrl, DataSourceProxy::setUrl);
            this.add(DataSourceProperty.DRIVER_CLASS_NAME, DataSourceProxy::getDriverClassName, DataSourceProxy::setDriverClassName);
            this.add(DataSourceProperty.USERNAME, DataSourceProxy::getUsername, DataSourceProxy::setUsername);
            this.add(DataSourceProperty.PASSWORD, DataSourceProxy::getPassword, DataSourceProxy::setPassword);
        }
    }

    private static class HikariDataSourceProperties
    extends MappedDataSourceProperties<HikariDataSource> {
        HikariDataSourceProperties() {
            this.add(DataSourceProperty.URL, HikariConfig::getJdbcUrl, HikariConfig::setJdbcUrl);
            this.add(DataSourceProperty.DRIVER_CLASS_NAME, HikariConfig::getDriverClassName, HikariConfig::setDriverClassName);
            this.add(DataSourceProperty.USERNAME, HikariConfig::getUsername, HikariConfig::setUsername);
            this.add(DataSourceProperty.PASSWORD, HikariConfig::getPassword, HikariConfig::setPassword);
        }
    }

    @FunctionalInterface
    private static interface Setter<T, V> {
        public void set(T var1, V var2) throws SQLException;
    }

    @FunctionalInterface
    private static interface Getter<T, V> {
        public V get(T var1) throws SQLException;
    }

    private static class ReflectionDataSourceProperties<T extends javax.sql.DataSource>
    implements DataSourceProperties<T> {
        private final Map<DataSourceProperty, Method> getters;
        private final Map<DataSourceProperty, Method> setters;
        private final Class<T> dataSourceType;

        ReflectionDataSourceProperties(Class<T> dataSourceType) {
            Assert.state(dataSourceType != null, "No supported DataSource type found");
            HashMap<DataSourceProperty, Method> getters = new HashMap<DataSourceProperty, Method>();
            HashMap<DataSourceProperty, Method> setters = new HashMap<DataSourceProperty, Method>();
            for (DataSourceProperty property : DataSourceProperty.values()) {
                this.putIfNotNull(getters, property, property.findGetter(dataSourceType));
                this.putIfNotNull(setters, property, property.findSetter(dataSourceType));
            }
            this.dataSourceType = dataSourceType;
            this.getters = Collections.unmodifiableMap(getters);
            this.setters = Collections.unmodifiableMap(setters);
        }

        private void putIfNotNull(Map<DataSourceProperty, Method> map2, DataSourceProperty property, Method method2) {
            if (method2 != null) {
                map2.put(property, method2);
            }
        }

        @Override
        public Class<T> getDataSourceInstanceType() {
            return this.dataSourceType;
        }

        @Override
        public boolean canSet(DataSourceProperty property) {
            return this.setters.containsKey((Object)property);
        }

        @Override
        public void set(T dataSource, DataSourceProperty property, String value2) {
            Method method2 = this.getMethod(property, this.setters);
            if (method2 != null) {
                ReflectionUtils.invokeMethod(method2, dataSource, value2);
            }
        }

        @Override
        public String get(T dataSource, DataSourceProperty property) {
            Method method2 = this.getMethod(property, this.getters);
            if (method2 != null) {
                return (String)ReflectionUtils.invokeMethod(method2, dataSource);
            }
            return null;
        }

        private Method getMethod(DataSourceProperty property, Map<DataSourceProperty, Method> methods2) {
            Method method2 = methods2.get((Object)property);
            if (method2 == null) {
                UnsupportedDataSourcePropertyException.throwIf(!property.isOptional(), () -> "Unable to find suitable method for " + property);
                return null;
            }
            ReflectionUtils.makeAccessible(method2);
            return method2;
        }
    }

    private static class MappedDataSourceProperty<T extends javax.sql.DataSource, V> {
        private final DataSourceProperty property;
        private final Class<V> type;
        private final Getter<T, V> getter;
        private final Setter<T, V> setter;

        MappedDataSourceProperty(DataSourceProperty property, Class<V> type2, Getter<T, V> getter, Setter<T, V> setter) {
            this.property = property;
            this.type = type2;
            this.getter = getter;
            this.setter = setter;
        }

        void set(T dataSource, String value2) {
            try {
                if (this.setter == null) {
                    UnsupportedDataSourcePropertyException.throwIf(!this.property.isOptional(), () -> "No setter mapped for '" + this.property + "' property");
                    return;
                }
                this.setter.set(dataSource, this.convertFromString(value2));
            }
            catch (SQLException ex) {
                throw new IllegalStateException(ex);
            }
        }

        String get(T dataSource) {
            try {
                if (this.getter == null) {
                    UnsupportedDataSourcePropertyException.throwIf(!this.property.isOptional(), () -> "No getter mapped for '" + this.property + "' property");
                    return null;
                }
                return this.convertToString(this.getter.get(dataSource));
            }
            catch (SQLException ex) {
                throw new IllegalStateException(ex);
            }
        }

        private V convertFromString(String value2) {
            if (String.class.equals(this.type)) {
                return (V)value2;
            }
            if (Class.class.equals(this.type)) {
                return (V)ClassUtils.resolveClassName(value2, null);
            }
            throw new IllegalStateException("Unsupported value type " + this.type);
        }

        private String convertToString(V value2) {
            if (String.class.equals(this.type)) {
                return (String)value2;
            }
            if (Class.class.equals(this.type)) {
                return ((Class)value2).getName();
            }
            throw new IllegalStateException("Unsupported value type " + this.type);
        }
    }
}

