/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.jackson;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.ObjectCodec;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.NullNode;
import java.io.Closeable;
import java.io.IOException;
import java.math.BigDecimal;
import java.math.BigInteger;
import org.springframework.util.Assert;

public abstract class JsonObjectDeserializer<T>
extends JsonDeserializer<T> {
    @Override
    public final T deserialize(JsonParser jp, DeserializationContext ctxt) throws IOException {
        try {
            ObjectCodec codec = jp.getCodec();
            JsonNode tree = (JsonNode)codec.readTree(jp);
            return this.deserializeObject(jp, ctxt, codec, tree);
        }
        catch (Exception ex) {
            if (ex instanceof IOException) {
                IOException ioException = (IOException)ex;
                throw ioException;
            }
            throw new JsonMappingException((Closeable)jp, "Object deserialize error", (Throwable)ex);
        }
    }

    protected abstract T deserializeObject(JsonParser var1, DeserializationContext var2, ObjectCodec var3, JsonNode var4) throws IOException;

    protected final <D> D nullSafeValue(JsonNode jsonNode, Class<D> type2) {
        Assert.notNull(type2, "Type must not be null");
        if (jsonNode == null) {
            return null;
        }
        if (type2 == String.class) {
            return (D)jsonNode.textValue();
        }
        if (type2 == Boolean.class) {
            return (D)Boolean.valueOf(jsonNode.booleanValue());
        }
        if (type2 == Long.class) {
            return (D)Long.valueOf(jsonNode.longValue());
        }
        if (type2 == Integer.class) {
            return (D)Integer.valueOf(jsonNode.intValue());
        }
        if (type2 == Short.class) {
            return (D)Short.valueOf(jsonNode.shortValue());
        }
        if (type2 == Double.class) {
            return (D)Double.valueOf(jsonNode.doubleValue());
        }
        if (type2 == Float.class) {
            return (D)Float.valueOf(jsonNode.floatValue());
        }
        if (type2 == BigDecimal.class) {
            return (D)jsonNode.decimalValue();
        }
        if (type2 == BigInteger.class) {
            return (D)jsonNode.bigIntegerValue();
        }
        throw new IllegalArgumentException("Unsupported value type " + type2.getName());
    }

    protected final JsonNode getRequiredNode(JsonNode tree, String fieldName) {
        Assert.notNull((Object)tree, "Tree must not be null");
        JsonNode node = tree.get(fieldName);
        Assert.state(node != null && !(node instanceof NullNode), () -> "Missing JSON field '" + fieldName + "'");
        return node;
    }
}

