/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.info;

import java.time.Instant;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeParseException;
import java.util.Objects;
import java.util.Properties;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Predicate;
import org.springframework.aot.hint.RuntimeHints;
import org.springframework.aot.hint.RuntimeHintsRegistrar;
import org.springframework.boot.info.InfoProperties;
import org.springframework.context.annotation.ImportRuntimeHints;

@ImportRuntimeHints(value={GitPropertiesRuntimeHints.class})
public class GitProperties
extends InfoProperties {
    static final Set<Coercer> coercers = Set.of(Coercer.milliseconds(), Coercer.dateTimePattern("yyyy-MM-dd'T'HH:mm:ssXXX"), Coercer.dateTimePattern("yyyy-MM-dd'T'HH:mm:ssZ"));

    public GitProperties(Properties entries2) {
        super(GitProperties.processEntries(entries2));
    }

    public String getBranch() {
        return this.get("branch");
    }

    public String getCommitId() {
        return this.get("commit.id");
    }

    public String getShortCommitId() {
        String shortId = this.get("commit.id.abbrev");
        if (shortId != null) {
            return shortId;
        }
        String id2 = this.getCommitId();
        if (id2 == null) {
            return null;
        }
        return id2.length() > 7 ? id2.substring(0, 7) : id2;
    }

    public Instant getCommitTime() {
        return this.getInstant("commit.time");
    }

    private static Properties processEntries(Properties properties) {
        GitProperties.coercePropertyToEpoch(properties, "commit.time");
        GitProperties.coercePropertyToEpoch(properties, "build.time");
        Object commitId = properties.get("commit.id");
        if (commitId != null) {
            properties.put("commit.id.full", commitId);
        }
        return properties;
    }

    private static void coercePropertyToEpoch(Properties properties, String key2) {
        String value2 = properties.getProperty(key2);
        if (value2 != null) {
            properties.setProperty(key2, coercers.stream().map(coercer -> coercer.apply(value2)).filter(Objects::nonNull).findFirst().orElse(value2));
        }
    }

    private record Coercer(Function<String, Long> action, Predicate<RuntimeException> ignoredExceptions) {
        String apply(String value2) {
            try {
                Long result2 = this.action.apply(value2);
                return result2 != null ? String.valueOf(result2) : null;
            }
            catch (RuntimeException ex) {
                if (this.ignoredExceptions.test(ex)) {
                    return null;
                }
                throw ex;
            }
        }

        static Coercer milliseconds() {
            return new Coercer(value2 -> Long.parseLong(value2) * 1000L, NumberFormatException.class::isInstance);
        }

        static Coercer dateTimePattern(String pattern) {
            return new Coercer(value2 -> DateTimeFormatter.ofPattern(pattern).parse((CharSequence)value2, Instant::from).toEpochMilli(), DateTimeParseException.class::isInstance);
        }
    }

    static class GitPropertiesRuntimeHints
    implements RuntimeHintsRegistrar {
        GitPropertiesRuntimeHints() {
        }

        @Override
        public void registerHints(RuntimeHints hints, ClassLoader classLoader) {
            hints.resources().registerPattern("git.properties");
        }
    }
}

