/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.info;

import java.time.DateTimeException;
import java.time.Instant;
import java.time.format.DateTimeFormatter;
import java.util.Properties;
import org.springframework.aot.hint.RuntimeHints;
import org.springframework.aot.hint.RuntimeHintsRegistrar;
import org.springframework.boot.info.InfoProperties;
import org.springframework.context.annotation.ImportRuntimeHints;

@ImportRuntimeHints(value={BuildPropertiesRuntimeHints.class})
public class BuildProperties
extends InfoProperties {
    public BuildProperties(Properties entries2) {
        super(BuildProperties.processEntries(entries2));
    }

    public String getGroup() {
        return this.get("group");
    }

    public String getArtifact() {
        return this.get("artifact");
    }

    public String getName() {
        return this.get("name");
    }

    public String getVersion() {
        return this.get("version");
    }

    public Instant getTime() {
        return this.getInstant("time");
    }

    private static Properties processEntries(Properties properties) {
        BuildProperties.coerceDate(properties, "time");
        return properties;
    }

    private static void coerceDate(Properties properties, String key2) {
        String value2 = properties.getProperty(key2);
        if (value2 != null) {
            try {
                String updatedValue = String.valueOf(DateTimeFormatter.ISO_INSTANT.parse((CharSequence)value2, Instant::from).toEpochMilli());
                properties.setProperty(key2, updatedValue);
            }
            catch (DateTimeException dateTimeException) {
                // empty catch block
            }
        }
    }

    static class BuildPropertiesRuntimeHints
    implements RuntimeHintsRegistrar {
        BuildPropertiesRuntimeHints() {
        }

        @Override
        public void registerHints(RuntimeHints hints, ClassLoader classLoader) {
            hints.resources().registerPattern("META-INF/build-info.properties");
        }
    }
}

