/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.env;

import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.springframework.boot.SpringApplication;
import org.springframework.boot.env.EnvironmentPostProcessor;
import org.springframework.boot.json.JsonParser;
import org.springframework.boot.json.JsonParserFactory;
import org.springframework.boot.origin.Origin;
import org.springframework.boot.origin.OriginLookup;
import org.springframework.boot.origin.PropertySourceOrigin;
import org.springframework.core.Ordered;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.core.env.MapPropertySource;
import org.springframework.core.env.MutablePropertySources;
import org.springframework.core.env.PropertySource;
import org.springframework.util.ClassUtils;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

public class SpringApplicationJsonEnvironmentPostProcessor
implements EnvironmentPostProcessor,
Ordered {
    public static final String SPRING_APPLICATION_JSON_PROPERTY = "spring.application.json";
    public static final String SPRING_APPLICATION_JSON_ENVIRONMENT_VARIABLE = "SPRING_APPLICATION_JSON";
    private static final String SERVLET_ENVIRONMENT_CLASS = "org.springframework.web.context.support.StandardServletEnvironment";
    private static final Set<String> SERVLET_ENVIRONMENT_PROPERTY_SOURCES = new LinkedHashSet<String>(Arrays.asList("jndiProperties", "servletContextInitParams", "servletConfigInitParams"));
    public static final int DEFAULT_ORDER = -2147483643;
    private int order = -2147483643;

    @Override
    public int getOrder() {
        return this.order;
    }

    public void setOrder(int order2) {
        this.order = order2;
    }

    @Override
    public void postProcessEnvironment(ConfigurableEnvironment environment2, SpringApplication application) {
        MutablePropertySources propertySources = environment2.getPropertySources();
        propertySources.stream().map(JsonPropertyValue::get).filter(Objects::nonNull).findFirst().ifPresent(v -> this.processJson(environment2, (JsonPropertyValue)v));
    }

    private void processJson(ConfigurableEnvironment environment2, JsonPropertyValue propertyValue) {
        JsonParser parser = JsonParserFactory.getJsonParser();
        Map<String, Object> map2 = parser.parseMap(propertyValue.getJson());
        if (!map2.isEmpty()) {
            this.addJsonPropertySource(environment2, new JsonPropertySource(propertyValue, this.flatten(map2)));
        }
    }

    private Map<String, Object> flatten(Map<String, Object> map2) {
        LinkedHashMap<String, Object> result2 = new LinkedHashMap<String, Object>();
        this.flatten(null, result2, map2);
        return result2;
    }

    private void flatten(String prefix, Map<String, Object> result2, Map<String, Object> map2) {
        Object namePrefix = prefix != null ? prefix + "." : "";
        map2.forEach((arg_0, arg_1) -> this.lambda$flatten$1((String)namePrefix, result2, arg_0, arg_1));
    }

    private void extract(String name2, Map<String, Object> result2, Object value2) {
        if (value2 instanceof Map) {
            Map map2 = (Map)value2;
            if (CollectionUtils.isEmpty(map2)) {
                result2.put(name2, value2);
                return;
            }
            this.flatten(name2, result2, (Map)value2);
        } else if (value2 instanceof Collection) {
            Collection collection = (Collection)value2;
            if (CollectionUtils.isEmpty(collection)) {
                result2.put(name2, value2);
                return;
            }
            int index2 = 0;
            for (Object object : collection) {
                this.extract(name2 + "[" + index2 + "]", result2, object);
                ++index2;
            }
        } else {
            result2.put(name2, value2);
        }
    }

    private void addJsonPropertySource(ConfigurableEnvironment environment2, PropertySource<?> source2) {
        String name2;
        MutablePropertySources sources = environment2.getPropertySources();
        if (sources.contains(name2 = this.findPropertySource(sources))) {
            sources.addBefore(name2, source2);
        } else {
            sources.addFirst(source2);
        }
    }

    private String findPropertySource(MutablePropertySources sources) {
        PropertySource servletPropertySource;
        if (ClassUtils.isPresent(SERVLET_ENVIRONMENT_CLASS, null) && (servletPropertySource = (PropertySource)sources.stream().filter(source2 -> SERVLET_ENVIRONMENT_PROPERTY_SOURCES.contains(source2.getName())).findFirst().orElse(null)) != null) {
            return servletPropertySource.getName();
        }
        return "systemProperties";
    }

    private /* synthetic */ void lambda$flatten$1(String namePrefix, Map result2, String key2, Object value2) {
        this.extract(namePrefix + key2, result2, value2);
    }

    private static class JsonPropertyValue {
        private static final String[] CANDIDATES = new String[]{"spring.application.json", "SPRING_APPLICATION_JSON"};
        private final PropertySource<?> propertySource;
        private final String propertyName;
        private final String json;

        JsonPropertyValue(PropertySource<?> propertySource, String propertyName, String json) {
            this.propertySource = propertySource;
            this.propertyName = propertyName;
            this.json = json;
        }

        String getJson() {
            return this.json;
        }

        Origin getOrigin() {
            return PropertySourceOrigin.get(this.propertySource, this.propertyName);
        }

        static JsonPropertyValue get(PropertySource<?> propertySource) {
            for (String candidate : CANDIDATES) {
                String string2;
                Object value2 = propertySource.getProperty(candidate);
                if (!(value2 instanceof String) || !StringUtils.hasLength(string2 = (String)value2)) continue;
                return new JsonPropertyValue(propertySource, candidate, string2);
            }
            return null;
        }
    }

    private static class JsonPropertySource
    extends MapPropertySource
    implements OriginLookup<String> {
        private final JsonPropertyValue propertyValue;

        JsonPropertySource(JsonPropertyValue propertyValue, Map<String, Object> source2) {
            super(SpringApplicationJsonEnvironmentPostProcessor.SPRING_APPLICATION_JSON_PROPERTY, source2);
            this.propertyValue = propertyValue;
        }

        @Override
        public Origin getOrigin(String key2) {
            return this.propertyValue.getOrigin();
        }
    }
}

