/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.env;

import java.util.HexFormat;
import java.util.OptionalInt;
import java.util.OptionalLong;
import java.util.Random;
import java.util.UUID;
import java.util.function.Function;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.core.env.MutablePropertySources;
import org.springframework.core.env.PropertySource;
import org.springframework.core.log.LogMessage;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

public class RandomValuePropertySource
extends PropertySource<Random> {
    public static final String RANDOM_PROPERTY_SOURCE_NAME = "random";
    private static final String PREFIX = "random.";
    private static final Log logger = LogFactory.getLog(RandomValuePropertySource.class);

    public RandomValuePropertySource() {
        this(RANDOM_PROPERTY_SOURCE_NAME);
    }

    public RandomValuePropertySource(String name2) {
        super(name2, new Random());
    }

    @Override
    public Object getProperty(String name2) {
        if (!name2.startsWith(PREFIX)) {
            return null;
        }
        logger.trace(LogMessage.format("Generating random property for '%s'", (Object)name2));
        return this.getRandomValue(name2.substring(PREFIX.length()));
    }

    private Object getRandomValue(String type2) {
        if (type2.equals("int")) {
            return ((Random)this.getSource()).nextInt();
        }
        if (type2.equals("long")) {
            return ((Random)this.getSource()).nextLong();
        }
        String range = this.getRange(type2, "int");
        if (range != null) {
            return this.getNextIntInRange(Range.of(range, Integer::parseInt));
        }
        range = this.getRange(type2, "long");
        if (range != null) {
            return this.getNextLongInRange(Range.of(range, Long::parseLong));
        }
        if (type2.equals("uuid")) {
            return UUID.randomUUID().toString();
        }
        return this.getRandomBytes();
    }

    private String getRange(String type2, String prefix) {
        if (type2.startsWith(prefix)) {
            int startIndex = prefix.length() + 1;
            if (type2.length() > startIndex) {
                return type2.substring(startIndex, type2.length() - 1);
            }
        }
        return null;
    }

    private int getNextIntInRange(Range<Integer> range) {
        OptionalInt first2 = ((Random)this.getSource()).ints(1L, range.getMin(), range.getMax()).findFirst();
        this.assertPresent(first2.isPresent(), range);
        return first2.getAsInt();
    }

    private long getNextLongInRange(Range<Long> range) {
        OptionalLong first2 = ((Random)this.getSource()).longs(1L, range.getMin(), range.getMax()).findFirst();
        this.assertPresent(first2.isPresent(), range);
        return first2.getAsLong();
    }

    private void assertPresent(boolean present, Range<?> range) {
        Assert.state(present, () -> "Could not get random number for range '" + range + "'");
    }

    private Object getRandomBytes() {
        byte[] bytes2 = new byte[16];
        ((Random)this.getSource()).nextBytes(bytes2);
        return HexFormat.of().withLowerCase().formatHex(bytes2);
    }

    public static void addToEnvironment(ConfigurableEnvironment environment2) {
        RandomValuePropertySource.addToEnvironment(environment2, logger);
    }

    static void addToEnvironment(ConfigurableEnvironment environment2, Log logger) {
        MutablePropertySources sources = environment2.getPropertySources();
        PropertySource<?> existing = sources.get(RANDOM_PROPERTY_SOURCE_NAME);
        if (existing != null) {
            logger.trace("RandomValuePropertySource already present");
            return;
        }
        RandomValuePropertySource randomSource = new RandomValuePropertySource(RANDOM_PROPERTY_SOURCE_NAME);
        if (sources.get("systemEnvironment") != null) {
            sources.addAfter("systemEnvironment", randomSource);
        } else {
            sources.addLast(randomSource);
        }
        logger.trace("RandomValuePropertySource add to Environment");
    }

    static final class Range<T extends Number> {
        private final String value;
        private final T min;
        private final T max;

        private Range(String value2, T min2, T max2) {
            this.value = value2;
            this.min = min2;
            this.max = max2;
        }

        T getMin() {
            return this.min;
        }

        T getMax() {
            return this.max;
        }

        public String toString() {
            return this.value;
        }

        static <T extends Number> Range<T> of(String value2, Function<String, T> parse2) {
            Number zero = (Number)parse2.apply("0");
            String[] tokens = StringUtils.commaDelimitedListToStringArray(value2);
            Number min2 = (Number)parse2.apply(tokens[0]);
            if (tokens.length == 1) {
                Assert.isTrue(((Comparable)((Object)min2)).compareTo(zero) > 0, "Bound must be positive.");
                return new Range<Number>(value2, zero, min2);
            }
            Number max2 = (Number)parse2.apply(tokens[1]);
            Assert.isTrue(((Comparable)((Object)min2)).compareTo(max2) < 0, "Lower bound must be less than upper bound.");
            return new Range<Number>(value2, min2, max2);
        }
    }
}

