/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.env;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.springframework.boot.env.OriginTrackedMapPropertySource;
import org.springframework.boot.env.OriginTrackedPropertiesLoader;
import org.springframework.boot.env.PropertySourceLoader;
import org.springframework.core.env.PropertySource;
import org.springframework.core.io.Resource;
import org.springframework.core.io.support.PropertiesLoaderUtils;

public class PropertiesPropertySourceLoader
implements PropertySourceLoader {
    private static final String XML_FILE_EXTENSION = ".xml";

    @Override
    public String[] getFileExtensions() {
        return new String[]{"properties", "xml"};
    }

    @Override
    public List<PropertySource<?>> load(String name2, Resource resource) throws IOException {
        List<Map<String, ?>> properties = this.loadProperties(resource);
        if (properties.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList propertySources = new ArrayList(properties.size());
        for (int i2 = 0; i2 < properties.size(); ++i2) {
            Object documentNumber = properties.size() != 1 ? " (document #" + i2 + ")" : "";
            propertySources.add(new OriginTrackedMapPropertySource(name2 + (String)documentNumber, Collections.unmodifiableMap(properties.get(i2)), true));
        }
        return propertySources;
    }

    private List<Map<String, ?>> loadProperties(Resource resource) throws IOException {
        String filename2 = resource.getFilename();
        ArrayList result2 = new ArrayList();
        if (filename2 != null && filename2.endsWith(XML_FILE_EXTENSION)) {
            result2.add(PropertiesLoaderUtils.loadProperties(resource));
        } else {
            List<OriginTrackedPropertiesLoader.Document> documents = new OriginTrackedPropertiesLoader(resource).load();
            documents.forEach(document -> result2.add(document.asMap()));
        }
        return result2;
    }
}

