/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.env;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.regex.Pattern;
import org.springframework.beans.factory.config.YamlProcessor;
import org.springframework.boot.origin.Origin;
import org.springframework.boot.origin.OriginTrackedValue;
import org.springframework.boot.origin.TextResourceOrigin;
import org.springframework.core.io.Resource;
import org.yaml.snakeyaml.DumperOptions;
import org.yaml.snakeyaml.LoaderOptions;
import org.yaml.snakeyaml.Yaml;
import org.yaml.snakeyaml.constructor.SafeConstructor;
import org.yaml.snakeyaml.error.Mark;
import org.yaml.snakeyaml.nodes.CollectionNode;
import org.yaml.snakeyaml.nodes.MappingNode;
import org.yaml.snakeyaml.nodes.Node;
import org.yaml.snakeyaml.nodes.NodeTuple;
import org.yaml.snakeyaml.nodes.ScalarNode;
import org.yaml.snakeyaml.nodes.Tag;
import org.yaml.snakeyaml.representer.Representer;
import org.yaml.snakeyaml.resolver.Resolver;

class OriginTrackedYamlLoader
extends YamlProcessor {
    private final Resource resource;

    OriginTrackedYamlLoader(Resource resource) {
        this.resource = resource;
        this.setResources(resource);
    }

    @Override
    protected Yaml createYaml() {
        LoaderOptions loaderOptions = new LoaderOptions();
        loaderOptions.setAllowDuplicateKeys(false);
        loaderOptions.setMaxAliasesForCollections(Integer.MAX_VALUE);
        loaderOptions.setAllowRecursiveKeys(true);
        loaderOptions.setCodePointLimit(Integer.MAX_VALUE);
        return this.createYaml(loaderOptions);
    }

    private Yaml createYaml(LoaderOptions loaderOptions) {
        OriginTrackingConstructor constructor2 = new OriginTrackingConstructor(loaderOptions);
        DumperOptions dumperOptions = new DumperOptions();
        Representer representer = new Representer(dumperOptions);
        NoTimestampResolver resolver = new NoTimestampResolver();
        return new Yaml(constructor2, representer, dumperOptions, loaderOptions, resolver);
    }

    List<Map<String, Object>> load() {
        ArrayList<Map<String, Object>> result2 = new ArrayList<Map<String, Object>>();
        this.process((properties, map2) -> result2.add(this.getFlattenedMap(map2)));
        return result2;
    }

    private class OriginTrackingConstructor
    extends SafeConstructor {
        OriginTrackingConstructor(LoaderOptions loadingConfig) {
            super(loadingConfig);
        }

        @Override
        public Object getData() throws NoSuchElementException {
            CharSequence charSequence;
            Object data2 = super.getData();
            if (data2 instanceof CharSequence && (charSequence = (CharSequence)data2).isEmpty()) {
                return null;
            }
            return data2;
        }

        @Override
        protected Object constructObject(Node node) {
            if (node instanceof CollectionNode && ((CollectionNode)node).getValue().isEmpty()) {
                return this.constructTrackedObject(node, super.constructObject(node));
            }
            if (node instanceof ScalarNode && !(node instanceof KeyScalarNode)) {
                return this.constructTrackedObject(node, super.constructObject(node));
            }
            if (node instanceof MappingNode) {
                MappingNode mappingNode = (MappingNode)node;
                this.replaceMappingNodeKeys(mappingNode);
            }
            return super.constructObject(node);
        }

        private void replaceMappingNodeKeys(MappingNode node) {
            ArrayList<NodeTuple> newValue = new ArrayList<NodeTuple>();
            node.getValue().stream().map(KeyScalarNode::get).forEach(newValue::add);
            node.setValue(newValue);
        }

        private Object constructTrackedObject(Node node, Object value2) {
            Origin origin = this.getOrigin(node);
            return OriginTrackedValue.of(this.getValue(value2), origin);
        }

        private Object getValue(Object value2) {
            return value2 != null ? value2 : "";
        }

        private Origin getOrigin(Node node) {
            Mark mark = node.getStartMark();
            TextResourceOrigin.Location location = new TextResourceOrigin.Location(mark.getLine(), mark.getColumn());
            return new TextResourceOrigin(OriginTrackedYamlLoader.this.resource, location);
        }
    }

    private static final class NoTimestampResolver
    extends Resolver {
        private NoTimestampResolver() {
        }

        @Override
        public void addImplicitResolver(Tag tag2, Pattern regexp2, String first2, int limit2) {
            if (tag2 == Tag.TIMESTAMP) {
                return;
            }
            super.addImplicitResolver(tag2, regexp2, first2, limit2);
        }
    }

    private static class KeyScalarNode
    extends ScalarNode {
        KeyScalarNode(ScalarNode node) {
            super(node.getTag(), node.getValue(), node.getStartMark(), node.getEndMark(), node.getScalarStyle());
        }

        static NodeTuple get(NodeTuple nodeTuple) {
            Node keyNode = nodeTuple.getKeyNode();
            Node valueNode = nodeTuple.getValueNode();
            return new NodeTuple(KeyScalarNode.get(keyNode), valueNode);
        }

        private static Node get(Node node) {
            if (node instanceof ScalarNode) {
                ScalarNode scalarNode = (ScalarNode)node;
                return new KeyScalarNode(scalarNode);
            }
            return node;
        }
    }
}

