/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.env;

import java.util.Map;
import org.springframework.boot.origin.Origin;
import org.springframework.boot.origin.OriginLookup;
import org.springframework.boot.origin.OriginTrackedValue;
import org.springframework.core.env.MapPropertySource;

public final class OriginTrackedMapPropertySource
extends MapPropertySource
implements OriginLookup<String> {
    private final boolean immutable;

    public OriginTrackedMapPropertySource(String name2, Map source2) {
        this(name2, source2, false);
    }

    public OriginTrackedMapPropertySource(String name2, Map source2, boolean immutable) {
        super(name2, source2);
        this.immutable = immutable;
    }

    @Override
    public Object getProperty(String name2) {
        Object value2 = super.getProperty(name2);
        if (value2 instanceof OriginTrackedValue) {
            OriginTrackedValue originTrackedValue = (OriginTrackedValue)value2;
            return originTrackedValue.getValue();
        }
        return value2;
    }

    @Override
    public Origin getOrigin(String name2) {
        Object value2 = super.getProperty(name2);
        if (value2 instanceof OriginTrackedValue) {
            OriginTrackedValue originTrackedValue = (OriginTrackedValue)value2;
            return originTrackedValue.getOrigin();
        }
        return null;
    }

    @Override
    public boolean isImmutable() {
        return this.immutable;
    }
}

