/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.diagnostics.analyzer;

import java.util.List;
import java.util.stream.Stream;
import org.springframework.boot.context.properties.source.ConfigurationPropertySources;
import org.springframework.boot.context.properties.source.InvalidConfigurationPropertyValueException;
import org.springframework.boot.diagnostics.AbstractFailureAnalyzer;
import org.springframework.boot.diagnostics.FailureAnalysis;
import org.springframework.boot.origin.Origin;
import org.springframework.boot.origin.OriginLookup;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.core.env.Environment;
import org.springframework.core.env.PropertySource;
import org.springframework.util.StringUtils;

class InvalidConfigurationPropertyValueFailureAnalyzer
extends AbstractFailureAnalyzer<InvalidConfigurationPropertyValueException> {
    private final ConfigurableEnvironment environment;

    InvalidConfigurationPropertyValueFailureAnalyzer(Environment environment2) {
        this.environment = (ConfigurableEnvironment)environment2;
    }

    @Override
    protected FailureAnalysis analyze(Throwable rootFailure, InvalidConfigurationPropertyValueException cause2) {
        List<Descriptor> descriptors = this.getDescriptors(cause2.getName());
        if (descriptors.isEmpty()) {
            descriptors = List.of(new Descriptor(null, cause2.getValue(), null));
        }
        StringBuilder description = new StringBuilder();
        this.appendDetails(description, cause2, descriptors);
        this.appendReason(description, cause2);
        this.appendAdditionalProperties(description, descriptors);
        return new FailureAnalysis(description.toString(), this.getAction(cause2), cause2);
    }

    private List<Descriptor> getDescriptors(String propertyName) {
        return this.getPropertySources().filter(source2 -> source2.containsProperty(propertyName)).map(source2 -> Descriptor.get(source2, propertyName)).toList();
    }

    private Stream<PropertySource<?>> getPropertySources() {
        if (this.environment == null) {
            return Stream.empty();
        }
        return this.environment.getPropertySources().stream().filter(source2 -> !ConfigurationPropertySources.isAttachedConfigurationPropertySource(source2));
    }

    private void appendDetails(StringBuilder message2, InvalidConfigurationPropertyValueException cause2, List<Descriptor> descriptors) {
        Descriptor mainDescriptor = descriptors.get(0);
        message2.append("Invalid value '").append(mainDescriptor.getValue()).append("' for configuration property '");
        message2.append(cause2.getName()).append("'");
        mainDescriptor.appendOrigin(message2);
        message2.append(".");
    }

    private void appendReason(StringBuilder message2, InvalidConfigurationPropertyValueException cause2) {
        if (StringUtils.hasText(cause2.getReason())) {
            message2.append(String.format(" Validation failed for the following reason:%n%n", new Object[0]));
            message2.append(cause2.getReason());
        } else {
            message2.append(" No reason was provided.");
        }
    }

    private void appendAdditionalProperties(StringBuilder message2, List<Descriptor> descriptors) {
        List<Descriptor> others = descriptors.subList(1, descriptors.size());
        if (!others.isEmpty()) {
            message2.append(String.format("%n%nAdditionally, this property is also set in the following property %s:%n%n", others.size() > 1 ? "sources" : "source"));
            for (Descriptor other : others) {
                message2.append("\t- In '").append(other.getPropertySource()).append("'");
                message2.append(" with the value '").append(other.getValue()).append("'");
                other.appendOrigin(message2);
                message2.append(String.format(".%n", new Object[0]));
            }
        }
    }

    private String getAction(InvalidConfigurationPropertyValueException cause2) {
        StringBuilder action = new StringBuilder();
        action.append("Review the value of the property");
        if (cause2.getReason() != null) {
            action.append(" with the provided reason");
        }
        action.append(".");
        return action.toString();
    }

    private static final class Descriptor {
        private final String propertySource;
        private final Object value;
        private final Origin origin;

        private Descriptor(String propertySource, Object value2, Origin origin) {
            this.propertySource = propertySource;
            this.value = value2;
            this.origin = origin;
        }

        String getPropertySource() {
            return this.propertySource;
        }

        Object getValue() {
            return this.value;
        }

        void appendOrigin(StringBuilder message2) {
            if (this.origin != null) {
                message2.append(" (originating from '").append(this.origin).append("')");
            }
        }

        static Descriptor get(PropertySource<?> source2, String propertyName) {
            Object value2 = source2.getProperty(propertyName);
            Origin origin = OriginLookup.getOrigin(source2, propertyName);
            return new Descriptor(source2.getName(), value2, origin);
        }
    }
}

