/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.diagnostics.analyzer;

import java.util.stream.Collectors;
import org.springframework.beans.factory.BeanCreationException;
import org.springframework.boot.context.properties.source.InvalidConfigurationPropertyNameException;
import org.springframework.boot.diagnostics.AbstractFailureAnalyzer;
import org.springframework.boot.diagnostics.FailureAnalysis;

class InvalidConfigurationPropertyNameFailureAnalyzer
extends AbstractFailureAnalyzer<InvalidConfigurationPropertyNameException> {
    InvalidConfigurationPropertyNameFailureAnalyzer() {
    }

    @Override
    protected FailureAnalysis analyze(Throwable rootFailure, InvalidConfigurationPropertyNameException cause2) {
        BeanCreationException exception2 = this.findCause(rootFailure, BeanCreationException.class);
        String action = String.format("Modify '%s' so that it conforms to the canonical names requirements.", cause2.getName());
        return new FailureAnalysis(this.buildDescription(cause2, exception2), action, cause2);
    }

    private String buildDescription(InvalidConfigurationPropertyNameException cause2, BeanCreationException exception2) {
        StringBuilder description = new StringBuilder(String.format("Configuration property name '%s' is not valid:%n", cause2.getName()));
        String invalid = cause2.getInvalidCharacters().stream().map(this::quote).collect(Collectors.joining(", "));
        description.append(String.format("%n    Invalid characters: %s", invalid));
        if (exception2 != null) {
            description.append(String.format("%n    Bean: %s", exception2.getBeanName()));
        }
        description.append(String.format("%n    Reason: Canonical names should be kebab-case ('-' separated), lowercase alpha-numeric characters and must start with a letter", new Object[0]));
        return description.toString();
    }

    private String quote(Character c) {
        return "'" + c + "'";
    }
}

