/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.diagnostics.analyzer;

import java.util.Collection;
import java.util.Collections;
import java.util.TreeSet;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.springframework.boot.context.properties.bind.BindException;
import org.springframework.boot.context.properties.bind.UnboundConfigurationPropertiesException;
import org.springframework.boot.context.properties.bind.validation.BindValidationException;
import org.springframework.boot.context.properties.source.ConfigurationProperty;
import org.springframework.boot.diagnostics.AbstractFailureAnalyzer;
import org.springframework.boot.diagnostics.FailureAnalysis;
import org.springframework.boot.diagnostics.analyzer.MissingParameterNamesFailureAnalyzer;
import org.springframework.core.convert.ConversionFailedException;
import org.springframework.util.StringUtils;

class BindFailureAnalyzer
extends AbstractFailureAnalyzer<BindException> {
    BindFailureAnalyzer() {
    }

    @Override
    protected FailureAnalysis analyze(Throwable rootFailure, BindException cause2) {
        Throwable rootCause = cause2.getCause();
        if (rootCause instanceof BindValidationException || rootCause instanceof UnboundConfigurationPropertiesException) {
            return null;
        }
        return this.analyzeGenericBindException(rootFailure, cause2);
    }

    private FailureAnalysis analyzeGenericBindException(Throwable rootFailure, BindException cause2) {
        FailureAnalysis missingParametersAnalysis = MissingParameterNamesFailureAnalyzer.analyzeForMissingParameters(rootFailure);
        StringBuilder description = new StringBuilder(String.format("%s:%n", cause2.getMessage()));
        ConfigurationProperty property = cause2.getProperty();
        this.buildDescription(description, property);
        description.append(String.format("%n    Reason: %s", this.getMessage(cause2)));
        if (missingParametersAnalysis != null) {
            MissingParameterNamesFailureAnalyzer.appendPossibility(description);
        }
        return this.getFailureAnalysis(description.toString(), cause2, missingParametersAnalysis);
    }

    private void buildDescription(StringBuilder description, ConfigurationProperty property) {
        if (property != null) {
            description.append(String.format("%n    Property: %s", property.getName()));
            description.append(String.format("%n    Value: \"%s\"", property.getValue()));
            description.append(String.format("%n    Origin: %s", property.getOrigin()));
        }
    }

    private String getMessage(BindException cause2) {
        Throwable rootCause = this.getRootCause(cause2.getCause());
        ConversionFailedException conversionFailure = this.findCause(cause2, ConversionFailedException.class);
        if (conversionFailure != null) {
            String message2 = "failed to convert " + conversionFailure.getSourceType() + " to " + conversionFailure.getTargetType();
            if (rootCause != null) {
                message2 = message2 + " (caused by " + this.getExceptionTypeAndMessage(rootCause) + ")";
            }
            return message2;
        }
        if (rootCause != null && StringUtils.hasText(rootCause.getMessage())) {
            return this.getExceptionTypeAndMessage(rootCause);
        }
        return this.getExceptionTypeAndMessage(cause2);
    }

    private Throwable getRootCause(Throwable cause2) {
        Throwable rootCause;
        for (rootCause = cause2; rootCause != null && rootCause.getCause() != null; rootCause = rootCause.getCause()) {
        }
        return rootCause;
    }

    private String getExceptionTypeAndMessage(Throwable ex) {
        String message2 = ex.getMessage();
        return ex.getClass().getName() + (String)(StringUtils.hasText(message2) ? ": " + message2 : "");
    }

    private FailureAnalysis getFailureAnalysis(String description, BindException cause2, FailureAnalysis missingParametersAnalysis) {
        StringBuilder action = new StringBuilder("Update your application's configuration");
        Collection<String> validValues = this.findValidValues(cause2);
        if (!validValues.isEmpty()) {
            action.append(String.format(". The following values are valid:%n", new Object[0]));
            validValues.forEach(value2 -> action.append(String.format("%n    %s", value2)));
        }
        if (missingParametersAnalysis != null) {
            action.append(String.format("%n%n%s", missingParametersAnalysis.getAction()));
        }
        return new FailureAnalysis(description, action.toString(), cause2);
    }

    private Collection<String> findValidValues(BindException ex) {
        ?[] enumConstants;
        ConversionFailedException conversionFailure = this.findCause(ex, ConversionFailedException.class);
        if (conversionFailure != null && (enumConstants = conversionFailure.getTargetType().getType().getEnumConstants()) != null) {
            return Stream.of(enumConstants).map(Object::toString).collect(Collectors.toCollection(TreeSet::new));
        }
        return Collections.emptySet();
    }
}

