/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.convert;

import java.time.Period;
import java.time.temporal.ChronoUnit;
import java.util.function.Function;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.springframework.util.Assert;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
public enum PeriodStyle {
    SIMPLE("^(?:([-+]?[0-9]+)Y)?(?:([-+]?[0-9]+)M)?(?:([-+]?[0-9]+)W)?(?:([-+]?[0-9]+)D)?$", 2){

        @Override
        public Period parse(String value2, ChronoUnit unit) {
            try {
                if (NUMERIC.matcher(value2).matches()) {
                    return Unit.fromChronoUnit(unit).parse(value2);
                }
                Matcher matcher = this.matcher(value2);
                Assert.state(matcher.matches(), "Does not match simple period pattern");
                Assert.isTrue(this.hasAtLeastOneGroupValue(matcher), () -> "'" + value2 + "' is not a valid simple period");
                int years = this.parseInt(matcher, 1);
                int months = this.parseInt(matcher, 2);
                int weeks = this.parseInt(matcher, 3);
                int days = this.parseInt(matcher, 4);
                return Period.of(years, months, Math.addExact(Math.multiplyExact(weeks, 7), days));
            }
            catch (Exception ex) {
                throw new IllegalArgumentException("'" + value2 + "' is not a valid simple period", ex);
            }
        }

        boolean hasAtLeastOneGroupValue(Matcher matcher) {
            for (int i2 = 0; i2 < matcher.groupCount(); ++i2) {
                if (matcher.group(i2 + 1) == null) continue;
                return true;
            }
            return false;
        }

        private int parseInt(Matcher matcher, int group2) {
            String value2 = matcher.group(group2);
            return value2 != null ? Integer.parseInt(value2) : 0;
        }

        @Override
        protected boolean matches(String value2) {
            return NUMERIC.matcher(value2).matches() || this.matcher(value2).matches();
        }

        @Override
        public String print(Period value2, ChronoUnit unit) {
            if (value2.isZero()) {
                return Unit.fromChronoUnit(unit).print(value2);
            }
            StringBuilder result2 = new StringBuilder();
            this.append(result2, value2, Unit.YEARS);
            this.append(result2, value2, Unit.MONTHS);
            this.append(result2, value2, Unit.DAYS);
            return result2.toString();
        }

        private void append(StringBuilder result2, Period value2, Unit unit) {
            if (!unit.isZero(value2)) {
                result2.append(unit.print(value2));
            }
        }
    }
    ,
    ISO8601("^[+-]?P.*$", 2){

        @Override
        public Period parse(String value2, ChronoUnit unit) {
            try {
                return Period.parse(value2);
            }
            catch (Exception ex) {
                throw new IllegalArgumentException("'" + value2 + "' is not a valid ISO-8601 period", ex);
            }
        }

        @Override
        public String print(Period value2, ChronoUnit unit) {
            return value2.toString();
        }
    };

    private static final Pattern NUMERIC;
    private final Pattern pattern;

    private PeriodStyle(String pattern, int flags2) {
        this.pattern = Pattern.compile(pattern, flags2);
    }

    protected boolean matches(String value2) {
        return this.pattern.matcher(value2).matches();
    }

    protected final Matcher matcher(String value2) {
        return this.pattern.matcher(value2);
    }

    public Period parse(String value2) {
        return this.parse(value2, null);
    }

    public abstract Period parse(String var1, ChronoUnit var2);

    public String print(Period value2) {
        return this.print(value2, null);
    }

    public abstract String print(Period var1, ChronoUnit var2);

    public static Period detectAndParse(String value2) {
        return PeriodStyle.detectAndParse(value2, null);
    }

    public static Period detectAndParse(String value2, ChronoUnit unit) {
        return PeriodStyle.detect(value2).parse(value2, unit);
    }

    public static PeriodStyle detect(String value2) {
        Assert.notNull((Object)value2, "Value must not be null");
        for (PeriodStyle candidate : PeriodStyle.values()) {
            if (!candidate.matches(value2)) continue;
            return candidate;
        }
        throw new IllegalArgumentException("'" + value2 + "' is not a valid period");
    }

    static {
        NUMERIC = Pattern.compile("^[-+]?[0-9]+$");
    }

    private static enum Unit {
        DAYS(ChronoUnit.DAYS, "d", Period::getDays, Period::ofDays),
        WEEKS(ChronoUnit.WEEKS, "w", null, Period::ofWeeks),
        MONTHS(ChronoUnit.MONTHS, "m", Period::getMonths, Period::ofMonths),
        YEARS(ChronoUnit.YEARS, "y", Period::getYears, Period::ofYears);

        private final ChronoUnit chronoUnit;
        private final String suffix;
        private final Function<Period, Integer> intValue;
        private final Function<Integer, Period> factory;

        private Unit(ChronoUnit chronoUnit, String suffix, Function<Period, Integer> intValue, Function<Integer, Period> factory) {
            this.chronoUnit = chronoUnit;
            this.suffix = suffix;
            this.intValue = intValue;
            this.factory = factory;
        }

        private Period parse(String value2) {
            return this.factory.apply(Integer.parseInt(value2));
        }

        private String print(Period value2) {
            return this.intValue(value2) + this.suffix;
        }

        private boolean isZero(Period value2) {
            return this.intValue(value2) == 0;
        }

        private int intValue(Period value2) {
            Assert.notNull(this.intValue, () -> "intValue cannot be extracted from " + this.name());
            return this.intValue.apply(value2);
        }

        private static Unit fromChronoUnit(ChronoUnit chronoUnit) {
            if (chronoUnit == null) {
                return DAYS;
            }
            for (Unit candidate : Unit.values()) {
                if (candidate.chronoUnit != chronoUnit) continue;
                return candidate;
            }
            throw new IllegalArgumentException("Unsupported unit " + chronoUnit);
        }
    }
}

