/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.convert;

import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.Map;
import org.springframework.core.convert.converter.Converter;
import org.springframework.core.convert.converter.ConverterFactory;
import org.springframework.util.Assert;
import org.springframework.util.LinkedMultiValueMap;

abstract class LenientObjectToEnumConverterFactory<T>
implements ConverterFactory<T, Enum<?>> {
    private static final Map<String, List<String>> ALIASES;

    LenientObjectToEnumConverterFactory() {
    }

    @Override
    public <E extends Enum<?>> Converter<T, E> getConverter(Class<E> targetType) {
        Class enumType;
        for (enumType = targetType; enumType != null && !enumType.isEnum(); enumType = enumType.getSuperclass()) {
        }
        Assert.notNull(enumType, () -> "The target type " + targetType.getName() + " does not refer to an enum");
        return new LenientToEnumConverter<E>(enumType);
    }

    static {
        LinkedMultiValueMap<String, String> aliases2 = new LinkedMultiValueMap<String, String>();
        aliases2.add("true", "on");
        aliases2.add("false", "off");
        ALIASES = Collections.unmodifiableMap(aliases2);
    }

    private class LenientToEnumConverter<E extends Enum>
    implements Converter<T, E> {
        private final Class<E> enumType;

        LenientToEnumConverter(Class<E> enumType) {
            this.enumType = enumType;
        }

        @Override
        public E convert(T source2) {
            String value2 = source2.toString().trim();
            if (value2.isEmpty()) {
                return null;
            }
            try {
                return Enum.valueOf(this.enumType, value2);
            }
            catch (Exception ex) {
                return this.findEnum(value2);
            }
        }

        private E findEnum(String value2) {
            String name2 = this.getCanonicalName(value2);
            List aliases2 = ALIASES.getOrDefault(name2, Collections.emptyList());
            for (Enum candidate : EnumSet.allOf(this.enumType)) {
                String candidateName = this.getCanonicalName(candidate.name());
                if (!name2.equals(candidateName) && !aliases2.contains(candidateName)) continue;
                return (E)candidate;
            }
            throw new IllegalArgumentException("No enum constant " + this.enumType.getCanonicalName() + "." + value2);
        }

        private String getCanonicalName(String name2) {
            StringBuilder canonicalName = new StringBuilder(name2.length());
            name2.chars().filter(Character::isLetterOrDigit).map(Character::toLowerCase).forEach(c -> canonicalName.append((char)c));
            return canonicalName.toString();
        }
    }
}

