/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.convert;

import java.time.Duration;
import java.time.temporal.ChronoUnit;
import java.util.function.Function;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
public enum DurationStyle {
    SIMPLE("^([+-]?\\d+)([a-zA-Z]{0,2})$"){

        @Override
        public Duration parse(String value2, ChronoUnit unit) {
            try {
                Matcher matcher = this.matcher(value2);
                Assert.state(matcher.matches(), "Does not match simple duration pattern");
                String suffix = matcher.group(2);
                return (StringUtils.hasLength(suffix) ? Unit.fromSuffix(suffix) : Unit.fromChronoUnit(unit)).parse(matcher.group(1));
            }
            catch (Exception ex) {
                throw new IllegalArgumentException("'" + value2 + "' is not a valid simple duration", ex);
            }
        }

        @Override
        public String print(Duration value2, ChronoUnit unit) {
            return Unit.fromChronoUnit(unit).print(value2);
        }
    }
    ,
    ISO8601("^[+-]?[pP].*$"){

        @Override
        public Duration parse(String value2, ChronoUnit unit) {
            try {
                return Duration.parse(value2);
            }
            catch (Exception ex) {
                throw new IllegalArgumentException("'" + value2 + "' is not a valid ISO-8601 duration", ex);
            }
        }

        @Override
        public String print(Duration value2, ChronoUnit unit) {
            return value2.toString();
        }
    };

    private final Pattern pattern;

    private DurationStyle(String pattern) {
        this.pattern = Pattern.compile(pattern);
    }

    protected final boolean matches(String value2) {
        return this.pattern.matcher(value2).matches();
    }

    protected final Matcher matcher(String value2) {
        return this.pattern.matcher(value2);
    }

    public Duration parse(String value2) {
        return this.parse(value2, null);
    }

    public abstract Duration parse(String var1, ChronoUnit var2);

    public String print(Duration value2) {
        return this.print(value2, null);
    }

    public abstract String print(Duration var1, ChronoUnit var2);

    public static Duration detectAndParse(String value2) {
        return DurationStyle.detectAndParse(value2, null);
    }

    public static Duration detectAndParse(String value2, ChronoUnit unit) {
        return DurationStyle.detect(value2).parse(value2, unit);
    }

    public static DurationStyle detect(String value2) {
        Assert.notNull((Object)value2, "Value must not be null");
        for (DurationStyle candidate : DurationStyle.values()) {
            if (!candidate.matches(value2)) continue;
            return candidate;
        }
        throw new IllegalArgumentException("'" + value2 + "' is not a valid duration");
    }

    static enum Unit {
        NANOS(ChronoUnit.NANOS, "ns", Duration::toNanos),
        MICROS(ChronoUnit.MICROS, "us", duration -> duration.toNanos() / 1000L),
        MILLIS(ChronoUnit.MILLIS, "ms", Duration::toMillis),
        SECONDS(ChronoUnit.SECONDS, "s", Duration::getSeconds),
        MINUTES(ChronoUnit.MINUTES, "m", Duration::toMinutes),
        HOURS(ChronoUnit.HOURS, "h", Duration::toHours),
        DAYS(ChronoUnit.DAYS, "d", Duration::toDays);

        private final ChronoUnit chronoUnit;
        private final String suffix;
        private final Function<Duration, Long> longValue;

        private Unit(ChronoUnit chronoUnit, String suffix, Function<Duration, Long> toUnit) {
            this.chronoUnit = chronoUnit;
            this.suffix = suffix;
            this.longValue = toUnit;
        }

        public Duration parse(String value2) {
            return Duration.of(Long.parseLong(value2), this.chronoUnit);
        }

        public String print(Duration value2) {
            return this.longValue(value2) + this.suffix;
        }

        public long longValue(Duration value2) {
            return this.longValue.apply(value2);
        }

        public static Unit fromChronoUnit(ChronoUnit chronoUnit) {
            if (chronoUnit == null) {
                return MILLIS;
            }
            for (Unit candidate : Unit.values()) {
                if (candidate.chronoUnit != chronoUnit) continue;
                return candidate;
            }
            throw new IllegalArgumentException("Unknown unit " + chronoUnit);
        }

        public static Unit fromSuffix(String suffix) {
            for (Unit candidate : Unit.values()) {
                if (!candidate.suffix.equalsIgnoreCase(suffix)) continue;
                return candidate;
            }
            throw new IllegalArgumentException("Unknown unit '" + suffix + "'");
        }
    }
}

