/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.convert;

import java.lang.reflect.Array;
import java.util.Collections;
import java.util.Set;
import org.springframework.boot.convert.Delimiter;
import org.springframework.core.convert.ConversionService;
import org.springframework.core.convert.TypeDescriptor;
import org.springframework.core.convert.converter.ConditionalGenericConverter;
import org.springframework.core.convert.converter.GenericConverter;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

final class DelimitedStringToArrayConverter
implements ConditionalGenericConverter {
    private final ConversionService conversionService;

    DelimitedStringToArrayConverter(ConversionService conversionService) {
        Assert.notNull((Object)conversionService, "ConversionService must not be null");
        this.conversionService = conversionService;
    }

    @Override
    public Set<GenericConverter.ConvertiblePair> getConvertibleTypes() {
        return Collections.singleton(new GenericConverter.ConvertiblePair(String.class, Object[].class));
    }

    @Override
    public boolean matches(TypeDescriptor sourceType, TypeDescriptor targetType) {
        return targetType.getElementTypeDescriptor() == null || this.conversionService.canConvert(sourceType, targetType.getElementTypeDescriptor());
    }

    @Override
    public Object convert(Object source2, TypeDescriptor sourceType, TypeDescriptor targetType) {
        if (source2 == null) {
            return null;
        }
        return this.convert((String)source2, sourceType, targetType);
    }

    private Object convert(String source2, TypeDescriptor sourceType, TypeDescriptor targetType) {
        Delimiter delimiter = targetType.getAnnotation(Delimiter.class);
        String[] elements = this.getElements(source2, delimiter != null ? delimiter.value() : ",");
        TypeDescriptor elementDescriptor = targetType.getElementTypeDescriptor();
        Object target2 = Array.newInstance(elementDescriptor.getType(), elements.length);
        for (int i2 = 0; i2 < elements.length; ++i2) {
            String sourceElement = elements[i2];
            Object targetElement = this.conversionService.convert(sourceElement.trim(), sourceType, elementDescriptor);
            Array.set(target2, i2, targetElement);
        }
        return target2;
    }

    private String[] getElements(String source2, String delimiter) {
        return StringUtils.delimitedListToStringArray(source2, "".equals(delimiter) ? null : delimiter);
    }
}

