/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.convert;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.springframework.boot.convert.CollectionToDelimitedStringConverter;
import org.springframework.core.convert.ConversionService;
import org.springframework.core.convert.TypeDescriptor;
import org.springframework.core.convert.converter.ConditionalGenericConverter;
import org.springframework.core.convert.converter.GenericConverter;
import org.springframework.util.ObjectUtils;

final class ArrayToDelimitedStringConverter
implements ConditionalGenericConverter {
    private final CollectionToDelimitedStringConverter delegate;

    ArrayToDelimitedStringConverter(ConversionService conversionService) {
        this.delegate = new CollectionToDelimitedStringConverter(conversionService);
    }

    @Override
    public Set<GenericConverter.ConvertiblePair> getConvertibleTypes() {
        return Collections.singleton(new GenericConverter.ConvertiblePair(Object[].class, String.class));
    }

    @Override
    public boolean matches(TypeDescriptor sourceType, TypeDescriptor targetType) {
        return this.delegate.matches(sourceType, targetType);
    }

    @Override
    public Object convert(Object source2, TypeDescriptor sourceType, TypeDescriptor targetType) {
        List<Object> list2 = Arrays.asList(ObjectUtils.toObjectArray(source2));
        return this.delegate.convert(list2, sourceType, targetType);
    }
}

