/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.context.properties.source;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.function.BiPredicate;
import org.springframework.boot.context.properties.source.ConfigurationPropertyName;
import org.springframework.boot.context.properties.source.PropertyMapper;

final class SystemEnvironmentPropertyMapper
implements PropertyMapper {
    public static final PropertyMapper INSTANCE = new SystemEnvironmentPropertyMapper();

    SystemEnvironmentPropertyMapper() {
    }

    @Override
    public List<String> map(ConfigurationPropertyName configurationPropertyName) {
        String legacyName;
        String name2 = this.convertName(configurationPropertyName);
        if (name2.equals(legacyName = this.convertLegacyName(configurationPropertyName))) {
            return Collections.singletonList(name2);
        }
        return Arrays.asList(name2, legacyName);
    }

    private String convertName(ConfigurationPropertyName name2) {
        return this.convertName(name2, name2.getNumberOfElements());
    }

    private String convertName(ConfigurationPropertyName name2, int numberOfElements) {
        StringBuilder result2 = new StringBuilder();
        for (int i2 = 0; i2 < numberOfElements; ++i2) {
            if (!result2.isEmpty()) {
                result2.append('_');
            }
            result2.append(name2.getElement(i2, ConfigurationPropertyName.Form.UNIFORM).toUpperCase(Locale.ENGLISH));
        }
        return result2.toString();
    }

    private String convertLegacyName(ConfigurationPropertyName name2) {
        StringBuilder result2 = new StringBuilder();
        for (int i2 = 0; i2 < name2.getNumberOfElements(); ++i2) {
            if (!result2.isEmpty()) {
                result2.append('_');
            }
            result2.append(this.convertLegacyNameElement(name2.getElement(i2, ConfigurationPropertyName.Form.ORIGINAL)));
        }
        return result2.toString();
    }

    private Object convertLegacyNameElement(String element) {
        return element.replace('-', '_').toUpperCase(Locale.ENGLISH);
    }

    @Override
    public ConfigurationPropertyName map(String propertySourceName) {
        return this.convertName(propertySourceName);
    }

    private ConfigurationPropertyName convertName(String propertySourceName) {
        try {
            return ConfigurationPropertyName.adapt(propertySourceName, '_', this::processElementValue);
        }
        catch (Exception ex) {
            return ConfigurationPropertyName.EMPTY;
        }
    }

    private CharSequence processElementValue(CharSequence value2) {
        String result2 = value2.toString().toLowerCase(Locale.ENGLISH);
        return SystemEnvironmentPropertyMapper.isNumber(result2) ? "[" + result2 + "]" : result2;
    }

    private static boolean isNumber(String string2) {
        return string2.chars().allMatch(Character::isDigit);
    }

    @Override
    public BiPredicate<ConfigurationPropertyName, ConfigurationPropertyName> getAncestorOfCheck() {
        return this::isAncestorOf;
    }

    private boolean isAncestorOf(ConfigurationPropertyName name2, ConfigurationPropertyName candidate) {
        return name2.isAncestorOf(candidate) || this.isLegacyAncestorOf(name2, candidate);
    }

    private boolean isLegacyAncestorOf(ConfigurationPropertyName name2, ConfigurationPropertyName candidate) {
        if (!this.hasDashedEntries(name2)) {
            return false;
        }
        ConfigurationPropertyName legacyCompatibleName = this.buildLegacyCompatibleName(name2);
        return legacyCompatibleName != null && legacyCompatibleName.isAncestorOf(candidate);
    }

    private ConfigurationPropertyName buildLegacyCompatibleName(ConfigurationPropertyName name2) {
        StringBuilder legacyCompatibleName = new StringBuilder();
        for (int i2 = 0; i2 < name2.getNumberOfElements(); ++i2) {
            if (i2 != 0) {
                legacyCompatibleName.append('.');
            }
            legacyCompatibleName.append(name2.getElement(i2, ConfigurationPropertyName.Form.DASHED).replace('-', '.'));
        }
        return ConfigurationPropertyName.ofIfValid(legacyCompatibleName);
    }

    boolean hasDashedEntries(ConfigurationPropertyName name2) {
        for (int i2 = 0; i2 < name2.getNumberOfElements(); ++i2) {
            if (name2.getElement(i2, ConfigurationPropertyName.Form.DASHED).indexOf(45) == -1) continue;
            return true;
        }
        return false;
    }
}

