/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.context.properties.source;

import java.util.Arrays;
import java.util.Collections;
import java.util.ConcurrentModificationException;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Set;
import java.util.function.BiPredicate;
import java.util.function.Supplier;
import java.util.stream.Stream;
import org.springframework.boot.context.properties.source.CachingConfigurationPropertySource;
import org.springframework.boot.context.properties.source.ConfigurationProperty;
import org.springframework.boot.context.properties.source.ConfigurationPropertyCaching;
import org.springframework.boot.context.properties.source.ConfigurationPropertyName;
import org.springframework.boot.context.properties.source.ConfigurationPropertyState;
import org.springframework.boot.context.properties.source.IterableConfigurationPropertySource;
import org.springframework.boot.context.properties.source.PropertyMapper;
import org.springframework.boot.context.properties.source.SoftReferenceConfigurationPropertyCache;
import org.springframework.boot.context.properties.source.SpringConfigurationPropertySource;
import org.springframework.boot.origin.Origin;
import org.springframework.boot.origin.OriginLookup;
import org.springframework.boot.origin.PropertySourceOrigin;
import org.springframework.core.env.EnumerablePropertySource;
import org.springframework.core.env.MapPropertySource;
import org.springframework.core.env.PropertySource;

class SpringIterableConfigurationPropertySource
extends SpringConfigurationPropertySource
implements IterableConfigurationPropertySource,
CachingConfigurationPropertySource {
    private final BiPredicate<ConfigurationPropertyName, ConfigurationPropertyName> ancestorOfCheck;
    private final SoftReferenceConfigurationPropertyCache<Mappings> cache;
    private volatile ConfigurationPropertyName[] configurationPropertyNames;

    SpringIterableConfigurationPropertySource(EnumerablePropertySource<?> propertySource, PropertyMapper ... mappers) {
        super(propertySource, mappers);
        this.assertEnumerablePropertySource();
        this.ancestorOfCheck = this.getAncestorOfCheck(mappers);
        this.cache = new SoftReferenceConfigurationPropertyCache(this.isImmutablePropertySource());
    }

    private BiPredicate<ConfigurationPropertyName, ConfigurationPropertyName> getAncestorOfCheck(PropertyMapper[] mappers) {
        BiPredicate<ConfigurationPropertyName, ConfigurationPropertyName> ancestorOfCheck = mappers[0].getAncestorOfCheck();
        for (int i2 = 1; i2 < mappers.length; ++i2) {
            ancestorOfCheck = ancestorOfCheck.or(mappers[i2].getAncestorOfCheck());
        }
        return ancestorOfCheck;
    }

    private void assertEnumerablePropertySource() {
        PropertySource propertySource = this.getPropertySource();
        if (propertySource instanceof MapPropertySource) {
            MapPropertySource mapSource = (MapPropertySource)propertySource;
            try {
                ((Map)mapSource.getSource()).size();
            }
            catch (UnsupportedOperationException ex) {
                throw new IllegalArgumentException("PropertySource must be fully enumerable");
            }
        }
    }

    @Override
    public ConfigurationPropertyCaching getCaching() {
        return this.cache;
    }

    @Override
    public ConfigurationProperty getConfigurationProperty(ConfigurationPropertyName name2) {
        if (name2 == null) {
            return null;
        }
        ConfigurationProperty configurationProperty = super.getConfigurationProperty(name2);
        if (configurationProperty != null) {
            return configurationProperty;
        }
        for (String candidate : this.getMappings().getMapped(name2)) {
            Object value2 = this.getPropertySource().getProperty(candidate);
            if (value2 == null) continue;
            Origin origin = PropertySourceOrigin.get(this.getPropertySource(), candidate);
            return ConfigurationProperty.of(this, name2, value2, origin);
        }
        return null;
    }

    @Override
    public Stream<ConfigurationPropertyName> stream() {
        ConfigurationPropertyName[] names2 = this.getConfigurationPropertyNames();
        return Arrays.stream(names2).filter(Objects::nonNull);
    }

    @Override
    public Iterator<ConfigurationPropertyName> iterator() {
        return new ConfigurationPropertyNamesIterator(this.getConfigurationPropertyNames());
    }

    @Override
    public ConfigurationPropertyState containsDescendantOf(ConfigurationPropertyName name2) {
        ConfigurationPropertyName[] candidates;
        ConfigurationPropertyState result2 = super.containsDescendantOf(name2);
        if (result2 != ConfigurationPropertyState.UNKNOWN) {
            return result2;
        }
        if (this.ancestorOfCheck == PropertyMapper.DEFAULT_ANCESTOR_OF_CHECK) {
            return this.getMappings().containsDescendantOf(name2, this.ancestorOfCheck);
        }
        for (ConfigurationPropertyName candidate : candidates = this.getConfigurationPropertyNames()) {
            if (candidate == null || !this.ancestorOfCheck.test(name2, candidate)) continue;
            return ConfigurationPropertyState.PRESENT;
        }
        return ConfigurationPropertyState.ABSENT;
    }

    private ConfigurationPropertyName[] getConfigurationPropertyNames() {
        if (!this.isImmutablePropertySource()) {
            return this.getMappings().getConfigurationPropertyNames(((EnumerablePropertySource)this.getPropertySource()).getPropertyNames());
        }
        ConfigurationPropertyName[] configurationPropertyNames = this.configurationPropertyNames;
        if (configurationPropertyNames == null) {
            configurationPropertyNames = this.getMappings().getConfigurationPropertyNames(((EnumerablePropertySource)this.getPropertySource()).getPropertyNames());
            this.configurationPropertyNames = configurationPropertyNames;
        }
        return configurationPropertyNames;
    }

    private Mappings getMappings() {
        return this.cache.get(this::createMappings, this::updateMappings);
    }

    private Mappings createMappings() {
        return new Mappings(this.getMappers(), this.isImmutablePropertySource(), this.ancestorOfCheck == PropertyMapper.DEFAULT_ANCESTOR_OF_CHECK);
    }

    private Mappings updateMappings(Mappings mappings) {
        mappings.updateMappings(((EnumerablePropertySource)this.getPropertySource())::getPropertyNames);
        return mappings;
    }

    private boolean isImmutablePropertySource() {
        PropertySource source2 = this.getPropertySource();
        if (source2 instanceof OriginLookup) {
            OriginLookup originLookup = (OriginLookup)((Object)source2);
            return originLookup.isImmutable();
        }
        if ("systemEnvironment".equals(source2.getName())) {
            return source2.getSource() == System.getenv();
        }
        return false;
    }

    protected EnumerablePropertySource<?> getPropertySource() {
        return (EnumerablePropertySource)super.getPropertySource();
    }

    private static class Mappings {
        private static final ConfigurationPropertyName[] EMPTY_NAMES_ARRAY = new ConfigurationPropertyName[0];
        private final PropertyMapper[] mappers;
        private final boolean immutable;
        private final boolean trackDescendants;
        private volatile Map<ConfigurationPropertyName, Set<String>> mappings;
        private volatile Map<String, ConfigurationPropertyName> reverseMappings;
        private volatile Map<ConfigurationPropertyName, Set<ConfigurationPropertyName>> descendants;
        private volatile ConfigurationPropertyName[] configurationPropertyNames;
        private volatile String[] lastUpdated;

        Mappings(PropertyMapper[] mappers, boolean immutable, boolean trackDescendants) {
            this.mappers = mappers;
            this.immutable = immutable;
            this.trackDescendants = trackDescendants;
        }

        void updateMappings(Supplier<String[]> propertyNames) {
            if (this.mappings == null || !this.immutable) {
                int count2 = 0;
                while (true) {
                    try {
                        this.updateMappings(propertyNames.get());
                        return;
                    }
                    catch (ConcurrentModificationException ex) {
                        if (count2++ <= 10) continue;
                        throw ex;
                    }
                    break;
                }
            }
        }

        private void updateMappings(String[] propertyNames) {
            Object[] lastUpdated = this.lastUpdated;
            if (lastUpdated != null && Arrays.equals(lastUpdated, propertyNames)) {
                return;
            }
            int size2 = propertyNames.length;
            Map<ConfigurationPropertyName, Set<String>> mappings = this.cloneOrCreate(this.mappings, size2);
            Map<String, ConfigurationPropertyName> reverseMappings = this.cloneOrCreate(this.reverseMappings, size2);
            Map<ConfigurationPropertyName, Set<ConfigurationPropertyName>> descendants = this.cloneOrCreate(this.descendants, size2);
            for (PropertyMapper propertyMapper : this.mappers) {
                for (String propertyName : propertyNames) {
                    ConfigurationPropertyName configurationPropertyName;
                    if (reverseMappings.containsKey(propertyName) || (configurationPropertyName = propertyMapper.map(propertyName)) == null || configurationPropertyName.isEmpty()) continue;
                    this.add(mappings, configurationPropertyName, propertyName);
                    reverseMappings.put(propertyName, configurationPropertyName);
                    if (!this.trackDescendants) continue;
                    this.addParents(descendants, configurationPropertyName);
                }
            }
            this.mappings = mappings;
            this.reverseMappings = reverseMappings;
            this.descendants = descendants;
            this.lastUpdated = this.immutable ? null : propertyNames;
            this.configurationPropertyNames = this.immutable ? reverseMappings.values().toArray(new ConfigurationPropertyName[0]) : null;
        }

        private <K, V> Map<K, V> cloneOrCreate(Map<K, V> source2, int size2) {
            return source2 != null ? new LinkedHashMap<K, V>(source2) : new LinkedHashMap(size2);
        }

        private void addParents(Map<ConfigurationPropertyName, Set<ConfigurationPropertyName>> descendants, ConfigurationPropertyName name2) {
            ConfigurationPropertyName parent = name2;
            while (!parent.isEmpty()) {
                this.add(descendants, parent, name2);
                parent = parent.getParent();
            }
        }

        private <K, T> void add(Map<K, Set<T>> map2, K key2, T value2) {
            map2.computeIfAbsent(key2, k -> new HashSet()).add(value2);
        }

        Set<String> getMapped(ConfigurationPropertyName configurationPropertyName) {
            return this.mappings.getOrDefault(configurationPropertyName, Collections.emptySet());
        }

        ConfigurationPropertyName[] getConfigurationPropertyNames(String[] propertyNames) {
            ConfigurationPropertyName[] names2 = this.configurationPropertyNames;
            if (names2 != null) {
                return names2;
            }
            Map<String, ConfigurationPropertyName> reverseMappings = this.reverseMappings;
            if (reverseMappings == null || reverseMappings.isEmpty()) {
                return EMPTY_NAMES_ARRAY;
            }
            names2 = new ConfigurationPropertyName[propertyNames.length];
            for (int i2 = 0; i2 < propertyNames.length; ++i2) {
                names2[i2] = reverseMappings.get(propertyNames[i2]);
            }
            return names2;
        }

        ConfigurationPropertyState containsDescendantOf(ConfigurationPropertyName name2, BiPredicate<ConfigurationPropertyName, ConfigurationPropertyName> ancestorOfCheck) {
            if (name2.isEmpty() && !this.descendants.isEmpty()) {
                return ConfigurationPropertyState.PRESENT;
            }
            Set candidates = this.descendants.getOrDefault(name2, Collections.emptySet());
            for (ConfigurationPropertyName candidate : candidates) {
                if (!ancestorOfCheck.test(name2, candidate)) continue;
                return ConfigurationPropertyState.PRESENT;
            }
            return ConfigurationPropertyState.ABSENT;
        }
    }

    private static class ConfigurationPropertyNamesIterator
    implements Iterator<ConfigurationPropertyName> {
        private final ConfigurationPropertyName[] names;
        private int index = 0;

        ConfigurationPropertyNamesIterator(ConfigurationPropertyName[] names2) {
            this.names = names2;
        }

        @Override
        public boolean hasNext() {
            this.skipNulls();
            return this.index < this.names.length;
        }

        @Override
        public ConfigurationPropertyName next() {
            this.skipNulls();
            if (this.index >= this.names.length) {
                throw new NoSuchElementException();
            }
            return this.names[this.index++];
        }

        private void skipNulls() {
            while (this.index < this.names.length) {
                if (this.names[this.index] != null) {
                    return;
                }
                ++this.index;
            }
        }
    }
}

