/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.context.properties.source;

import java.util.Map;
import java.util.Random;
import org.springframework.boot.context.properties.source.ConfigurationProperty;
import org.springframework.boot.context.properties.source.ConfigurationPropertyName;
import org.springframework.boot.context.properties.source.ConfigurationPropertySource;
import org.springframework.boot.context.properties.source.ConfigurationPropertyState;
import org.springframework.boot.context.properties.source.DefaultPropertyMapper;
import org.springframework.boot.context.properties.source.PropertyMapper;
import org.springframework.boot.context.properties.source.SpringIterableConfigurationPropertySource;
import org.springframework.boot.context.properties.source.SystemEnvironmentPropertyMapper;
import org.springframework.boot.origin.Origin;
import org.springframework.boot.origin.PropertySourceOrigin;
import org.springframework.core.env.EnumerablePropertySource;
import org.springframework.core.env.PropertySource;
import org.springframework.core.env.SystemEnvironmentPropertySource;
import org.springframework.util.Assert;

class SpringConfigurationPropertySource
implements ConfigurationPropertySource {
    private static final PropertyMapper[] DEFAULT_MAPPERS = new PropertyMapper[]{DefaultPropertyMapper.INSTANCE};
    private static final PropertyMapper[] SYSTEM_ENVIRONMENT_MAPPERS = new PropertyMapper[]{SystemEnvironmentPropertyMapper.INSTANCE, DefaultPropertyMapper.INSTANCE};
    private final PropertySource<?> propertySource;
    private final PropertyMapper[] mappers;

    SpringConfigurationPropertySource(PropertySource<?> propertySource, PropertyMapper ... mappers) {
        Assert.notNull(propertySource, "PropertySource must not be null");
        Assert.isTrue(mappers.length > 0, "Mappers must contain at least one item");
        this.propertySource = propertySource;
        this.mappers = mappers;
    }

    @Override
    public ConfigurationProperty getConfigurationProperty(ConfigurationPropertyName name2) {
        if (name2 == null) {
            return null;
        }
        for (PropertyMapper mapper : this.mappers) {
            try {
                for (String candidate : mapper.map(name2)) {
                    Object value2 = this.getPropertySource().getProperty(candidate);
                    if (value2 == null) continue;
                    Origin origin = PropertySourceOrigin.get(this.propertySource, candidate);
                    return ConfigurationProperty.of(this, name2, value2, origin);
                }
            }
            catch (Exception exception2) {
                // empty catch block
            }
        }
        return null;
    }

    @Override
    public ConfigurationPropertyState containsDescendantOf(ConfigurationPropertyName name2) {
        PropertySource underlyingPropertySource;
        PropertySource<?> source2 = this.getPropertySource();
        Object underlyingSource = source2.getSource();
        if (underlyingSource instanceof Random) {
            return SpringConfigurationPropertySource.containsDescendantOfForRandom("random", name2);
        }
        if (underlyingSource instanceof PropertySource && (underlyingPropertySource = (PropertySource)underlyingSource).getSource() instanceof Random) {
            return SpringConfigurationPropertySource.containsDescendantOfForRandom(source2.getName(), name2);
        }
        return ConfigurationPropertyState.UNKNOWN;
    }

    private static ConfigurationPropertyState containsDescendantOfForRandom(String prefix, ConfigurationPropertyName name2) {
        if (name2.getNumberOfElements() > 1 && name2.getElement(0, ConfigurationPropertyName.Form.DASHED).equals(prefix)) {
            return ConfigurationPropertyState.PRESENT;
        }
        return ConfigurationPropertyState.ABSENT;
    }

    @Override
    public Object getUnderlyingSource() {
        return this.propertySource;
    }

    protected PropertySource<?> getPropertySource() {
        return this.propertySource;
    }

    protected final PropertyMapper[] getMappers() {
        return this.mappers;
    }

    public String toString() {
        return this.propertySource.toString();
    }

    static SpringConfigurationPropertySource from(PropertySource<?> source2) {
        Assert.notNull(source2, "Source must not be null");
        PropertyMapper[] mappers = SpringConfigurationPropertySource.getPropertyMappers(source2);
        if (SpringConfigurationPropertySource.isFullEnumerable(source2)) {
            return new SpringIterableConfigurationPropertySource((EnumerablePropertySource)source2, mappers);
        }
        return new SpringConfigurationPropertySource(source2, mappers);
    }

    private static PropertyMapper[] getPropertyMappers(PropertySource<?> source2) {
        if (source2 instanceof SystemEnvironmentPropertySource && SpringConfigurationPropertySource.hasSystemEnvironmentName(source2)) {
            return SYSTEM_ENVIRONMENT_MAPPERS;
        }
        return DEFAULT_MAPPERS;
    }

    private static boolean hasSystemEnvironmentName(PropertySource<?> source2) {
        String name2 = source2.getName();
        return "systemEnvironment".equals(name2) || name2.endsWith("-systemEnvironment");
    }

    private static boolean isFullEnumerable(PropertySource<?> source2) {
        PropertySource<?> rootSource = SpringConfigurationPropertySource.getRootSource(source2);
        Object obj = rootSource.getSource();
        if (obj instanceof Map) {
            Map map2 = (Map)obj;
            try {
                map2.size();
            }
            catch (UnsupportedOperationException ex) {
                return false;
            }
        }
        return source2 instanceof EnumerablePropertySource;
    }

    private static PropertySource<?> getRootSource(PropertySource<?> source2) {
        Object obj;
        while ((obj = source2.getSource()) instanceof PropertySource) {
            PropertySource propertySource;
            source2 = propertySource = (PropertySource)obj;
        }
        return source2;
    }
}

