/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.context.properties.source;

import org.springframework.boot.context.properties.source.ConfigurationProperty;
import org.springframework.boot.context.properties.source.ConfigurationPropertyName;
import org.springframework.boot.context.properties.source.ConfigurationPropertySource;
import org.springframework.boot.context.properties.source.ConfigurationPropertyState;
import org.springframework.util.Assert;

class PrefixedConfigurationPropertySource
implements ConfigurationPropertySource {
    private final ConfigurationPropertySource source;
    private final ConfigurationPropertyName prefix;

    PrefixedConfigurationPropertySource(ConfigurationPropertySource source2, String prefix) {
        Assert.notNull((Object)source2, "Source must not be null");
        Assert.hasText(prefix, "Prefix must not be empty");
        this.source = source2;
        this.prefix = ConfigurationPropertyName.of(prefix);
    }

    protected final ConfigurationPropertyName getPrefix() {
        return this.prefix;
    }

    @Override
    public ConfigurationProperty getConfigurationProperty(ConfigurationPropertyName name2) {
        ConfigurationProperty configurationProperty = this.source.getConfigurationProperty(this.getPrefixedName(name2));
        if (configurationProperty == null) {
            return null;
        }
        return ConfigurationProperty.of(configurationProperty.getSource(), name2, configurationProperty.getValue(), configurationProperty.getOrigin());
    }

    private ConfigurationPropertyName getPrefixedName(ConfigurationPropertyName name2) {
        return this.prefix.append(name2);
    }

    @Override
    public ConfigurationPropertyState containsDescendantOf(ConfigurationPropertyName name2) {
        return this.source.containsDescendantOf(this.getPrefixedName(name2));
    }

    @Override
    public Object getUnderlyingSource() {
        return this.source.getUnderlyingSource();
    }

    protected ConfigurationPropertySource getSource() {
        return this.source;
    }
}

