/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.context.properties.source;

import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.stream.Stream;
import org.springframework.boot.context.properties.source.ConfigurationProperty;
import org.springframework.boot.context.properties.source.ConfigurationPropertyName;
import org.springframework.boot.context.properties.source.DefaultPropertyMapper;
import org.springframework.boot.context.properties.source.IterableConfigurationPropertySource;
import org.springframework.boot.context.properties.source.PropertyMapper;
import org.springframework.boot.context.properties.source.SpringIterableConfigurationPropertySource;
import org.springframework.core.env.MapPropertySource;
import org.springframework.util.Assert;

public class MapConfigurationPropertySource
implements IterableConfigurationPropertySource {
    private static final PropertyMapper[] DEFAULT_MAPPERS = new PropertyMapper[]{DefaultPropertyMapper.INSTANCE};
    private final Map<String, Object> source = new LinkedHashMap<String, Object>();
    private final IterableConfigurationPropertySource delegate;

    public MapConfigurationPropertySource() {
        this(Collections.emptyMap());
    }

    public MapConfigurationPropertySource(Map<?, ?> map2) {
        MapPropertySource mapPropertySource = new MapPropertySource("source", this.source);
        this.delegate = new SpringIterableConfigurationPropertySource(mapPropertySource, DEFAULT_MAPPERS);
        this.putAll(map2);
    }

    public void putAll(Map<?, ?> map2) {
        Assert.notNull(map2, "Map must not be null");
        this.assertNotReadOnlySystemAttributesMap(map2);
        map2.forEach(this::put);
    }

    public void put(Object name2, Object value2) {
        this.source.put(name2 != null ? name2.toString() : null, value2);
    }

    @Override
    public Object getUnderlyingSource() {
        return this.source;
    }

    @Override
    public ConfigurationProperty getConfigurationProperty(ConfigurationPropertyName name2) {
        return this.delegate.getConfigurationProperty(name2);
    }

    @Override
    public Iterator<ConfigurationPropertyName> iterator() {
        return this.delegate.iterator();
    }

    @Override
    public Stream<ConfigurationPropertyName> stream() {
        return this.delegate.stream();
    }

    private void assertNotReadOnlySystemAttributesMap(Map<?, ?> map2) {
        try {
            map2.size();
        }
        catch (UnsupportedOperationException ex) {
            throw new IllegalArgumentException("Security restricted maps are not supported", ex);
        }
    }
}

