/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.context.properties.source;

import java.util.List;

public class InvalidConfigurationPropertyNameException
extends RuntimeException {
    private final CharSequence name;
    private final List<Character> invalidCharacters;

    public InvalidConfigurationPropertyNameException(CharSequence name2, List<Character> invalidCharacters) {
        super("Configuration property name '" + name2 + "' is not valid");
        this.name = name2;
        this.invalidCharacters = invalidCharacters;
    }

    public List<Character> getInvalidCharacters() {
        return this.invalidCharacters;
    }

    public CharSequence getName() {
        return this.name;
    }

    public static void throwIfHasInvalidChars(CharSequence name2, List<Character> invalidCharacters) {
        if (!invalidCharacters.isEmpty()) {
            throw new InvalidConfigurationPropertyNameException(name2, invalidCharacters);
        }
    }
}

