/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.context.properties.source;

import org.springframework.boot.context.properties.source.ConfigurationProperty;
import org.springframework.boot.context.properties.source.ConfigurationPropertyName;
import org.springframework.boot.context.properties.source.ConfigurationPropertySource;
import org.springframework.boot.origin.Origin;
import org.springframework.boot.origin.OriginLookup;
import org.springframework.core.env.PropertySource;

class ConfigurationPropertySourcesPropertySource
extends PropertySource<Iterable<ConfigurationPropertySource>>
implements OriginLookup<String> {
    ConfigurationPropertySourcesPropertySource(String name2, Iterable<ConfigurationPropertySource> source2) {
        super(name2, source2);
    }

    @Override
    public boolean containsProperty(String name2) {
        return this.findConfigurationProperty(name2) != null;
    }

    @Override
    public Object getProperty(String name2) {
        ConfigurationProperty configurationProperty = this.findConfigurationProperty(name2);
        return configurationProperty != null ? configurationProperty.getValue() : null;
    }

    @Override
    public Origin getOrigin(String name2) {
        return Origin.from(this.findConfigurationProperty(name2));
    }

    private ConfigurationProperty findConfigurationProperty(String name2) {
        try {
            return this.findConfigurationProperty(ConfigurationPropertyName.of(name2, true));
        }
        catch (Exception ex) {
            return null;
        }
    }

    ConfigurationProperty findConfigurationProperty(ConfigurationPropertyName name2) {
        if (name2 == null) {
            return null;
        }
        for (ConfigurationPropertySource configurationPropertySource : (Iterable)this.getSource()) {
            ConfigurationProperty configurationProperty = configurationPropertySource.getConfigurationProperty(name2);
            if (configurationProperty == null) continue;
            return configurationProperty;
        }
        return null;
    }
}

