/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.context.properties.source;

import org.springframework.boot.context.properties.source.ConfigurationProperty;
import org.springframework.boot.context.properties.source.ConfigurationPropertyName;
import org.springframework.boot.context.properties.source.ConfigurationPropertySources;
import org.springframework.boot.context.properties.source.ConfigurationPropertySourcesPropertySource;
import org.springframework.boot.context.properties.source.SpringConfigurationPropertySources;
import org.springframework.core.env.AbstractPropertyResolver;
import org.springframework.core.env.MutablePropertySources;
import org.springframework.core.env.PropertySources;
import org.springframework.core.env.PropertySourcesPropertyResolver;

class ConfigurationPropertySourcesPropertyResolver
extends AbstractPropertyResolver {
    private final MutablePropertySources propertySources;
    private final DefaultResolver defaultResolver;

    ConfigurationPropertySourcesPropertyResolver(MutablePropertySources propertySources) {
        this.propertySources = propertySources;
        this.defaultResolver = new DefaultResolver(propertySources);
    }

    @Override
    public boolean containsProperty(String key2) {
        ConfigurationPropertyName name2;
        ConfigurationPropertySourcesPropertySource attached = this.getAttached();
        if (attached != null && (name2 = ConfigurationPropertyName.of(key2, true)) != null) {
            try {
                return attached.findConfigurationProperty(name2) != null;
            }
            catch (Exception exception2) {
                // empty catch block
            }
        }
        return this.defaultResolver.containsProperty(key2);
    }

    @Override
    public String getProperty(String key2) {
        return this.getProperty(key2, String.class, true);
    }

    @Override
    public <T> T getProperty(String key2, Class<T> targetValueType) {
        return this.getProperty(key2, targetValueType, true);
    }

    @Override
    protected String getPropertyAsRawString(String key2) {
        return this.getProperty(key2, String.class, false);
    }

    private <T> T getProperty(String key2, Class<T> targetValueType, boolean resolveNestedPlaceholders) {
        Object value2 = this.findPropertyValue(key2);
        if (value2 == null) {
            return null;
        }
        if (resolveNestedPlaceholders && value2 instanceof String) {
            String string2 = (String)value2;
            value2 = this.resolveNestedPlaceholders(string2);
        }
        return this.convertValueIfNecessary(value2, targetValueType);
    }

    private Object findPropertyValue(String key2) {
        ConfigurationPropertyName name2;
        ConfigurationPropertySourcesPropertySource attached = this.getAttached();
        if (attached != null && (name2 = ConfigurationPropertyName.of(key2, true)) != null) {
            try {
                ConfigurationProperty configurationProperty = attached.findConfigurationProperty(name2);
                return configurationProperty != null ? configurationProperty.getValue() : null;
            }
            catch (Exception exception2) {
                // empty catch block
            }
        }
        return this.defaultResolver.getProperty(key2, Object.class, false);
    }

    private ConfigurationPropertySourcesPropertySource getAttached() {
        SpringConfigurationPropertySources springSource;
        Iterable attachedSource;
        ConfigurationPropertySourcesPropertySource attached = (ConfigurationPropertySourcesPropertySource)ConfigurationPropertySources.getAttached(this.propertySources);
        Iterable iterable = attachedSource = attached != null ? (Iterable)attached.getSource() : null;
        if (attachedSource instanceof SpringConfigurationPropertySources && (springSource = (SpringConfigurationPropertySources)attachedSource).isUsingSources(this.propertySources)) {
            return attached;
        }
        return null;
    }

    static class DefaultResolver
    extends PropertySourcesPropertyResolver {
        DefaultResolver(PropertySources propertySources) {
            super(propertySources);
        }

        @Override
        public <T> T getProperty(String key2, Class<T> targetValueType, boolean resolveNestedPlaceholders) {
            return super.getProperty(key2, targetValueType, resolveNestedPlaceholders);
        }
    }
}

